% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVarsEddy.R
\name{getVarsEddy}
\alias{getVarsEddy}
\title{Extract list of eddy covariance tables from HDF5 files}
\usage{
getVarsEddy(filepath)
}
\arguments{
\item{filepath}{The folder containing the H5 file [character]}
}
\value{
A data frame of the metadata for each data table in the HDF5 file
}
\description{
Extracts a list of table metadata from a single HDF5 file. Specific to eddy covariance data product: DP4.00200.001. Can inform inputs to stackEddy(); variables listed in 'name' are available inputs to the 'var' parameter in stackEddy().
}
\examples{
\dontrun{
# read variables from a file in a hypothetical filepath
ec.vars <- getVarsEddy(filepath='/data/NEON.D19.BONA.DP4.00200.001.nsae.2017-12.basic.h5')
}
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
