% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pediatrics_03b_population.R
\name{pediatrics_03b_population}
\alias{pediatrics_03b_population}
\title{Pediatrics-03B Populations}
\usage{
pediatrics_03b_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  exam_table = NULL,
  medications_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  eexam_01_col,
  eexam_02_col,
  emedications_03_col,
  emedications_04_col
)
}
\arguments{
\item{df}{A data frame or tibble containing emergency response records.
Default is \code{NULL}.}

\item{patient_scene_table}{A data.frame or tibble containing only ePatient
and eScene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data.frame or tibble containing only the eResponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{exam_table}{A data.frame or tibble containing only the eExam fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{medications_table}{A data.frame or tibble containing only the
eMedications fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{erecord_01_col}{Column for unique EMS record identifiers.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column giving the calculated age value.}

\item{epatient_16_col}{Column giving the provided age unit value.}

\item{eresponse_05_col}{Column containing the EMS response codes.}

\item{eexam_01_col}{Column containing documented weight information.}

\item{eexam_02_col}{Another column for weight documentation, if applicable.}

\item{emedications_03_col}{Column indicating medication administration.}

\item{emedications_04_col}{Column listing medications administered.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
Filters data down to the target populations for Pediatrics-03B, and
categorizes records to identify needed information for the calculations.

Identifies key categories related to diabetes/hypoglycemia incidents in an
EMS dataset, specifically focusing on cases where 911 was called for
diabetes/hypoglycemia distress, certain medications were administered, and a
weight is taken. This function segments the data into pediatric populations,
computing the proportion of cases that have a documented weight.
}
\examples{

# create tables to test correct functioning
patient_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

)

response_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  eresponse_05 = rep(2205001, 5)

)

exam_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  eexam_01 = c(60, 59, 58, 57, 56),
  eexam_02 = c("Red", "Purple", "Grey", "Yellow", "Orange")
)

medications_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  emedications_03 = rep("stuff", 5),
  emedications_04 = c("Inhalation", "pill", "liquid", "pill", "liquid"),

)

# test the success of the function

result <- pediatrics_03b_population(patient_scene_table = patient_table,
                           response_table = response_table,
                           exam_table = exam_table,
                           medications_table = medications_table,
                           erecord_01_col = erecord_01,
                           incident_date_col = incident_date,
                           patient_DOB_col = patient_dob,
                           epatient_15_col = epatient_15,
                           epatient_16_col = epatient_16,
                           eresponse_05_col = eresponse_05,
                           emedications_03_col = emedications_03,
                           emedications_04_col = emedications_04,
                           eexam_01_col = eexam_01,
                           eexam_02_col = eexam_02
                           )

# show the results of filtering at each step
result$filter_process


}
\author{
Nicolas Foss, Ed.D., MS
}
