% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omitMatrix.R
\name{omitMatrix}
\alias{omitMatrix}
\title{Compute TAI or TDI Profiles Omitting a Given Gene}
\usage{
omitMatrix(ExpressionSet)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}
}
\value{
a numeric matrix storing TAI or TDI profile for each omitted gene i.
}
\description{
For each gene i, exclude the corresponding gene i from the global
 PhyloExpressionSet or DivergenceExpressionSet and compute the \code{\link{TAI}} or \code{\link{TDI}} 
 profile for the corresponding global PhyloExpressionSet or DivergenceExpressionSet
 with excluded gene i. 
 
 This procedure results in a TAI or TDI profile Matrix storing the TAI or TDI profile for each omitted gene i.
}
\examples{

# read standard phylotranscriptomics data
data(PhyloExpressionSetExample)
data(DivergenceExpressionSetExample)

# example PhyloExpressionSet
omMatrix_ps <- omitMatrix(PhyloExpressionSetExample)

# example DivergenceExpressionSet
omMatrix_ds <- omitMatrix(DivergenceExpressionSetExample)


}
\author{
Hajk-Georg Drost
}

