## ----, echo = FALSE, message = FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(myTAI)
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(myTAI)
#  
#  # load an example PhyloExpressionSet stored in the myTAI package
#  data(PhyloExpressionSetExample)
#  
#  # load an example DivergenceExpressionSet stored in the myTAI package
#  data(DivergenceExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  
#  head(PhyloExpressionSetExample, 3) # head of an example standard PhyloExpressionSet
#  

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # used by all myTAI functions to check the validity of the PhyloExpressionSet standard
#  is.ExpressionSet(PhyloExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # used a non standard PhyloExpressionSet
#  head(PhyloExpressionSetExample[ , 2:5], 2)

## ----, error = TRUE,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  is.ExpressionSet(PhyloExpressionSetExample[ , 2:5])

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(DivergenceExpressionSetExample, 3) # head of an example standard DivergenceExpressionSet

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # displaying the phylostratum distribution (gene frequency distribution)
#  # of a PhyloExpressionSet as absolute frequency distribution
#  PlotDistribution(PhyloExpressionSetExample, xlab = "Phylostratum")

## ----, fig.width= 7, fig.height= 4,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # as relative frequency distribution
#  PlotDistribution(PhyloExpressionSetExample, as.ratio = TRUE, xlab = "Phylostratum", cex = 0.7)

## ----, fig.width= 5, fig.height= 4,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the correlation between Phylostratum and Divergence-Stratum assignments
#  # of the intersecting set of genes that are stored within the PhyloExpressionSet
#  # and DivergenceExpressionSet
#  
#  PlotCorrelation(PhyloExpressionSetExample, DivergenceExpressionSetExample,
#                  method = "kendall", linearModel = TRUE)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # simple use of the PlotPattern function
#  # to plot the TAI of a given PhyloExpressionSet
#  PlotPattern(PhyloExpressionSetExample, type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TAI")

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # using the PlotPattern function
#  # to plot the TAI of a given PhyloExpressionSet
#  # and to perform the ReductiveHourglassTest to quantify
#  # the statisical significance of the visual hourglass pattern
#  PlotPattern(PhyloExpressionSetExample, TestStatistic = "ReductiveHourglassTest",
#              modules = list(early = 1:2, mid = 3:5, late = 6:7),
#              type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TAI")

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # using the shaded.area argument to visualize the chosen modules
#  PlotPattern(PhyloExpressionSetExample, TestStatistic = "ReductiveHourglassTest",
#              modules = list(early = 1:2, mid = 3:5, late = 6:7),
#              shaded.area = TRUE, type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TAI")

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # using the PlotPattern function
#  # to plot the TAI of a given PhyloExpressionSet
#  # and to perform the EarlyConservationTest to test the
#  # Early Conservation Hypothesis for the observed phylotranscriptomic pattern
#  PlotPattern(PhyloExpressionSetExample, TestStatistic = "EarlyConservationTest",
#              modules = list(early = 1:2, mid = 3:5, late = 6:7),
#              type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TAI")

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # simply getting the TAI values of a given PhyloExpressionSet
#  TAI(PhyloExpressionSetExample)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # simple use of the PlotPattern function
#  # to plot the TDI of a given DivergenceExpressionSet
#  PlotPattern(DivergenceExpressionSetExample, type = "l", lwd = 6,
#              xlab = "Ontogeny", ylab = "TDI")

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # using the PlotPattern function
#  # to plot the TDI of a given DivergenceExpressionSet
#  # and to perform the ReductiveHourglassTest to quantify
#  # the statisical significance of the visual hourglass pattern
#  PlotPattern(DivergenceExpressionSetExample, TestStatistic = "ReductiveHourglassTest",
#              modules = list(early = 1:2, mid = 3:5, late = 6:7),
#              type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TDI")

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # using the PlotPattern function
#  # to plot the TDI of a given DivergenceExpressionSet
#  # and to perform the EarlyConservationTest
#  # test the Early Conservation Hypothesis
#  PlotPattern(DivergenceExpressionSetExample, TestStatistic = "EarlyConservationTest",
#              modules = list(early = 1:2, mid = 3:5, late = 6:7),
#              type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TDI")

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # getting the TDI values of a given DivergenceExpressionSet
#  TDI(DivergenceExpressionSetExample)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean gene expression of each Phylostratum class
#  PlotMeans(PhyloExpressionSetExample, Groups = list(1:12), legendName = "PS",
#            xlab = "Ontogeny", lty = 1, cex = 0.7, lwd = 5)

## ----, fig.height= 5, fig.width=9,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean gene expression of each Phylostratum class
#  PlotMeans(PhyloExpressionSetExample, Groups = list(1:3, 4:12), legendName = "PS",
#            xlab = "Ontogeny", lty = 1, cex = 0.7, lwd = 5)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # using the age.apply() function implemented in the myTAI package
#  # to compute the mean expression levels of all Phylostrata
#  age.apply(PhyloExpressionSetExample, colMeans)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean gene expression of each Divergence-Stratum class
#  PlotMeans(DivergenceExpressionSetExample, Groups = list(1:10), legendName = "DS",
#            xlab = "Ontogeny", lty = 1, cex = 0.7, lwd = 5)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # using the age.apply() function to compute the mean expression levels
#  # of all Divergence-Strata
#  age.apply(DivergenceExpressionSetExample, colMeans)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean gene expression of each Phylostratum class
#  PlotRE(PhyloExpressionSetExample, Groups = list(1:10), legendName = "PS",
#            xlab = "Ontogeny", lty = 1, cex = 0.7, lwd = 5)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean gene expression of each Divergence-Stratum class
#  PlotRE(DivergenceExpressionSetExample, Groups = list(1:10), legendName = "DS",
#            xlab = "Ontogeny", lty = 1, cex = 0.7, lwd = 5)

## ----,fig.height=5, fig.width=9,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean gene expression of each Phylostratum class
#  PlotRE(PhyloExpressionSetExample, Groups = list(1:3, 4:12), legendName = "PS",
#            xlab = "Ontogeny", lty = 1, cex = 0.7, lwd = 5)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # getting the relative expression levels for all Phylostrata
#  REMatrix(PhyloExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # getting the relative expression levels for all Divergence-Strata
#  REMatrix(DivergenceExpressionSetExample)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # getting the relative expression levels for all Phylostrata
#  age.apply(PhyloExpressionSetExample, RE)

## ----,fig.height=5, fig.width=7,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean relative expression of two Phylostratum groups
#  PlotBarRE(PhyloExpressionSetExample, Groups = list(1:3, 4:12),
#            xlab = "Ontogeny", ylab = "Mean Relative Expression", cex = 2)

## ----, fig.height=5,fig.width=7,eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean relative expression of two Phylostratum groups
#  PlotBarRE(PhyloExpressionSetExample, Groups = list(1:3, 4:12), ratio = TRUE,
#            xlab = "Ontogeny", ylab = "Mean Relative Expression", cex = 2)

## ----, fig.width=7,eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # visualizing the mean relative expression of three Phylostratum groups
#  PlotBarRE(PhyloExpressionSetExample, Groups = list(1:3, 4:6, 7:12), wLength = 0.05,
#            xlab = "Ontogeny", ylab = "Mean Relative Expression", cex = 2)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # cex = 0.5, cex.lab = 0.5, cex.axis = 0.5
#  PlotPattern(PhyloExpressionSetExample, type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TAI",
#              cex = 0.5, cex.lab = 0.5, cex.axis = 0.5)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # cex = 2, cex.lab = 1, cex.axis = 0.5
#  PlotPattern(PhyloExpressionSetExample, type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TAI",
#              cex = 2, cex.lab = 1, cex.axis = 0.5)

## ----, fig.width= 7, fig.height= 5,eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # cex = 0.5, cex.lab = 0.7, cex.axis = 1.5
#  PlotPattern(PhyloExpressionSetExample, type = "l", lwd = 6, xlab = "Ontogeny", ylab = "TAI",
#              cex = 0.5, cex.lab = 0.7, cex.axis = 1.5)

