% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam_irf-class.R
\name{summary.mvgam_irf}
\alias{summary.mvgam_irf}
\title{Posterior summary of impulse responses}
\usage{
\method{summary}{mvgam_irf}(object, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{an object of class \code{mvgam_irf} obtained using the
\code{irf()} function. This object will contain draws from the posterior
distribution of the impulse responses.}

\item{probs}{The upper and lower percentiles to be computed by the \code{quantile} function,
in addition to the median}

\item{...}{ignored}
}
\value{
A long-format \code{tibble} reporting the posterior median,
upper and lower percentiles of the impulse responses of each series to shocks
from each of the other series at all horizons.
}
\description{
This function takes an \code{mvgam_irf} object and
calculates a posterior summary of the impulse responses of each
series to shocks from each of the other series, at all horizons
}
\seealso{
\code{\link{irf}}, \code{\link{plot.mvgam_irf}}
}
\author{
Nicholas J Clark
}
