% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition.R
\name{branch_condition}
\alias{branch_condition}
\title{Create a new branch condition.}
\usage{
branch_condition(x, y, reject = FALSE)
}
\arguments{
\item{x}{option 1}

\item{y}{option 2}

\item{reject}{if TRUE, the condition rejects universes
with option 1 and option 2}
}
\value{
A \code{branch_condition} object.
}
\description{
A branch condition conditions option \code{x} to
depend on option \code{y}. When the branch condition
is added to a \code{mverse} object, option \code{x}
is executed only when \code{y} is. Use \code{reject = TRUE},
to negate the condition.
}
\examples{
# Example branches.
y <- mutate_branch(alldeaths, log(alldeaths + 1))
model <- formula_branch(y ~ MasFem * strength, y ~ MasFem + strength)
# Define a new branch condition.
match_poisson <- branch_condition(alldeaths, poisson)
# Define a branch condition that reject an option dependent on another.
match_log_lin <- branch_condition(log(alldeaths + 1), poisson, reject = TRUE)

}
\seealso{
Other branch condition functions: 
\code{\link{add_branch_condition}()}
}
\concept{branch condition functions}
