\name{box.plot}
\alias{box.plot}
\title{
Generate box plots
}
\description{
Generates box plots of each variable (column) present in the matrix provided and according to the class specification provided
}
\usage{
box.plot(file)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{file}{
a connection or a character string giving the name of the file containing information to plot
}
}
\details{
This function can be used by calling the function 'univariate', in which 'box.plot' is implemented. The groups are distinguished according to the class vector provided within the dataset. In particular, the file provided has to be formatted with the first column indicating the name of each sample and the second column indicating the class of belonging of each sample.
}
\value{
A list of box plots is generated and written in a directory called 'BoxPlot', within the directory 'Univariate' (generated by the function 'univariate'), in the working directory.
}
\author{
Edoardo Gaude, Dimitrios Spiliotopoulos, Francesca Chignola, Silvia Mari, Andrea Spitaleri and Michela Ghitti
}

\seealso{
univariate
}
\examples{

## The function is currently defined as
function (file) 
{
    pwdfile = paste(getwd(), "/Univariate/DataTable.csv", sep = "")
    file = pwdfile
    x <- read.csv(file, sep = ",", header = TRUE)
    x.x = x[, 3:ncol(x)]
    rownames(x.x) = x[, 2]
    k = matrix(x[, 1], ncol = 1)
    colnames(k)[1] = "Class"
    x.x = cbind(k, x.x)
    sorted = x.x[order(x.x[, 1]), ]
    sorted.x = as.matrix(sorted[, -1], ncol = ncol(sorted) - 
        1)
    g = c()
    for (i in 1:nrow(sorted)) {
        if (any(g == sorted[i, 1])) {
            g = g
        }
        else {
            g = matrix(c(g, sorted[i, 1]), ncol = 1)
        }
    }
    NoF = nrow(g)
    dirbox = paste(getwd(), "/Univariate/BoxPlot/", sep = "")
    dir.create(dirbox)
    for (i in 2:ncol(x.x)) {
        name = paste(getwd(), "/Univariate/BoxPlot/", colnames(x.x)[i], 
            ".pdf", sep = "")
        pdf(name)
        boxplot(x.x[, i] ~ x.x[, 1], boxfill = c(seq(1, NoF)), 
            ylab = colnames(x.x)[i], xlab = "Groups", border = "grey30", 
            main = paste("Boxplot ", colnames(x.x)[i], sep = ""))
        dev.off()
    }
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
