% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_typical.R
\name{df_typical}
\alias{df_typical}
\title{Find typical levels of explanatory variables in a model/dataset.}
\usage{
df_typical(data = NULL, nlevels = 3, at = list(), model = NULL, ...)
}
\arguments{
\item{data}{optional data frame from which to extract levels for explanatory variables}

\item{nlevels}{how many levels to construct for input variables.
For quantitative variables, this is a suggestion. Set to \code{Inf} to get all levels
for categorical variables and 100 levels for quantitative variables.}

\item{at}{named list giving specific values at which to hold the variables. Use this to
override the automatic generation of levels for any or all explanatory variables.}

\item{model}{the model to display graphically}

\item{...}{a more concise mechanism to passing desired values for variables}
}
\value{
A dataframe containing all combinations of the selected values for
the explanatory variables. If there are p explanatory variables,
there will be about \code{nlevels^p} cases.
}
\description{
This function tries to choose sensible values of the explanatory variables
from the data used to build a model or any other specified data.
(or from data specified with the \code{data =} argument.)
}
\details{
For categorical variables, the most populated levels are used. For quantitative
variables, a sequence of \code{pretty()} values is generated.

For categorical variables, will return the nlevels most popular levels, unless
the levels are specified explicitly in an argument.
}
\examples{
\dontrun{
df_typical(mosaicData::Galton, nlevels = 2, father = 70, mother = 68, nkids = 3)
df_typical(mosaicData::Galton, nlevels = 2)
mod1 <- lm(wage ~ age * sex + sector, data = mosaicData::CPS85)
df_typical(model = mod1, nlevels = 3)
}
}
