\name{plo_inter}
\alias{plo_inter}

\title{
Plot of Interactions
}

\description{
Plots the interaction between two categorical supplementary variables for a PLS regression.
}

\usage{
plo_inter(object, var1, var2, excl1 = NULL, excl2 = NULL,
  comps = c(1,2), shapesize = 1, textsize = 3,
  force = 1, max.overlaps = Inf,
  lines = TRUE, dashes = TRUE)
}

\arguments{
  \item{object}{an object of class \code{mvr} from \code{pls} package}
  \item{var1}{factor. The first categorical supplementary variable.}
  \item{var2}{factor. The second categorical supplementary variable.}  \item{excl1}{character vector of categories from the var1 to exclude from the plot. If NULL (default), all the supplementary categories are plotted.}
  \item{excl2}{character vector of categories from the var2 to exclude from the plot. If NULL (default), all the supplementary categories are plotted.}
  \item{comps}{the components to use. Default is \code{c(1,2)}.}
  \item{shapesize}{Size of the shapes. Default is 1.}
  \item{textsize}{Size of the labels of categories. Default is 3.}
  \item{force}{Force of repulsion between overlapping text labels. Defaults to 1. If 0, labels are not repelled at all.}
  \item{max.overlaps}{Exclude text labels that overlap too many things. Defaults to Inf, which means no labels are excluded.}
  \item{lines}{logical. Whether to add colored lines between the points of the categories of v1. Default is TRUE.}
  \item{dashes}{logical. Whether to add gray dashed lines between the points of the categories of v2. Default is TRUE.}
}

\value{
a \code{ggplot2} object
}

\references{
Martens, H., Næs, T. (1989) Multivariate calibration. Chichester: Wiley.

Tenenhaus, M. (1998) La Regression PLS. Theorie et Pratique. Editions TECHNIP, Paris.
}

\author{
Nicolas Robette
}

\seealso{
\code{\link{plo_sup}}, \code{\link{plo_part}}
}

\examples{
library(pls)
data(mpg, package = "ggplot2")
pls <- mvr(displ ~ cty + hwy + cyl,
           ncomp = 3,
           data = mpg,
           validation = "CV",
           method = "oscorespls")
supvars <- data.frame(class = factor(mpg$class), trans = factor(mpg$trans))
plo_inter(pls, factor(mpg$class), factor(mpg$trans), lines = FALSE, dashes = FALSE)
}

\keyword{ multivariate }
\keyword{ misc }
