% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelStudioOptions.R
\name{modelStudioOptions}
\alias{modelStudioOptions}
\title{Modify options and pass them to modelStudio}
\usage{
modelStudioOptions(...)
}
\arguments{
\item{...}{Options to change, \code{option_name = value}.}
}
\value{
\code{list} of options for \code{modelStudio}.

\subsection{Main options:}{
\describe{
\item{scale_plot}{\code{TRUE} Makes every plot the same height, ignores \code{bar_width}.}
\item{show_subtitle}{\code{TRUE} Should the subtitle be displayed?}
\item{subtitle}{\code{label} parameter from \code{explainer}.}
\item{margin_*}{Plot margins. Change \code{margin_left} for longer/shorter axis labels.}
\item{w}{\code{420} in px. Inner plot width.}
\item{h}{\code{280} in px. Inner plot height.}
\item{bar_width}{\code{16} in px. Default width of bars for all plots,
ignored when \code{scale_plot = TRUE}.}
\item{line_size}{\code{2} in px. Default width of lines for all plots.}
\item{point_size}{\code{3} in px. Default point radius for all plots.}
\item{[bar,line,point]_color}{\code{[#46bac2,#46bac2,#371ea3]}}
\item{positive_color}{\code{#8bdcbe} for Break Down and SHAP Values bars.}
\item{negative_color}{\code{#f05a71} for Break Down and SHAP Values bars.}
\item{default_color}{\code{#371ea3} for Break Down bar and highlighted line.}
}
}
\subsection{Plot specific options:}{
\code{**} is a two letter code unique to each plot, might be
one of \code{[bd,sv,cp,fi,pd,ad,fd,tv,at]}.\cr

\describe{
\item{**_title}{Plot specific title. Default varies.}
\item{**_subtitle}{Plot specific subtitle. Default is \code{subtitle}.}
\item{**_bar_width}{Plot specific width of bars. Default is \code{bar_width},
ignored when \code{scale_plot = TRUE}.}
\item{**_line_size}{\code{line_size} Plot specific width of lines. Default is \code{line_size}.}
\item{**_point_size}{Plot specific point radius. Default is \code{point_size}.}
\item{**_*_color}{Plot specific \code{[bar,line,point]} color. Default is \code{[bar,line,point]_color}.}
}
}
}
\description{
This function returns default options for \code{\link{modelStudio}}.
It is possible to modify values of this list and pass it to the \code{options}
parameter in the main function. \strong{WARNING: Editing default options may cause
unintended behavior.}
}
\examples{
library("modelStudio")

apartments <- DALEX::apartments

model_apartments <- glm(m2.price ~. ,
                        data = apartments)

explain_apartments <- DALEX::explain(model_apartments,
                                     data = apartments[,-1],
                                     y = apartments[,1],
                                     verbose = FALSE)

new_apartments <- apartments[1:2,]
rownames(new_apartments) <- c("ap1","ap2")

op <- modelStudioOptions(
  show_subtitle = TRUE,
  bd_subtitle = "Hello World",
  line_size = 5,
  point_size = 9,
  line_color = "pink",
  point_color = "purple",
  bd_positive_color = "yellow",
  bd_negative_color = "orange"
)

modelStudio(explain_apartments, new_apartments,
            facet_dim = c(1,2), N = 100, B = 10, show_info = FALSE,
            options = op)

}
