% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAC_spatial.R
\name{rare_curve}
\alias{rare_curve}
\title{Species rarefaction curve}
\usage{
rare_curve(abund_vec)
}
\arguments{
\item{abund_vec}{Species abundance distribution of the community (integer vector)}
}
\value{
Numeric Vector with expected species richness in samples of 1, 2, 3 ... n individuals
}
\description{
Expected species richness as a function of sample size
}
\details{
This function essentially evaluates \code{\link{spec_sample}} for
sample sizes from 1 to \code{sum(abund_vec)}. It is similar to the function
\code{\link[vegan:rarefy]{vegan:rarecurve}} in the R package \code{\link{vegan}}.
}
\examples{
sad1 <- sim_sad(100, 2000, sad_type = "lnorm", sad_coef = list("meanlog" = 2,
                                                                "sdlog" = 1))
rc1 <- rare_curve(sad1)
plot(rc1, type = "l", xlab = "Sample size", ylab = "Expected species richness")

}
\references{
Gotelli & Colwell 2001. Quantifying biodiversity: procedures and pitfalls
in the measurement and comparison of species richness. Ecology Letters 4, 379--391.
}
