% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleTable-methods-exported.R
\name{SingleTable.summary}
\alias{SingleTable.summary}
\title{Summarize the object of class \code{singletable}.}
\usage{
SingleTable.summary(
  single_table_Obj,
  alpha = 0.05,
  verbose = TRUE,
  digit = 3,
  control = list()
)
}
\arguments{
\item{single_table_Obj}{The object created by \code{SingleTable.create} and fitted by \code{SingleTable.modelFit}.}

\item{alpha}{a numeric value specifying the significant level. Default value sets to 0.05.}

\item{verbose}{a logical value; if TRUE(default), the detailed summary messages will display.}

\item{digit}{an integer value specifying how many decimal places to keep. Default value sets to 3.}

\item{control}{a list can be specified to control the fitting process.}
}
\value{
A list with the following components: measure, model, posterior mean, posterior median, equal tail CI, and HDR CI.
}
\description{
Summarize model of the single table analysis fitted by \code{SingleTable.modelFit}.
}
\examples{
## Assume we have a 2x2 table:{{40,56},{49,60}} and set prior parameters as a1=b1=a2=b2=rho=0.5.
 \donttest{
 library(mmeta)
 library(ggplot2)
 ## If exact method is used, the codes for sampling method are similar.
 ## Create object \code{single_table_obj_exact}
 single_table_obj_exact <- SingleTable.create(a1=0.5,b1=0.5,
 a2=0.5,b2=0.5,rho=0.5, y1=40, n1=96, y2=49, n2=109,model="Sarmanov",measure="OR")
 ## model fit
 single_table_obj_exact <- SingleTable.modelFit(single_table_obj_exact, method = 'exact')
 ## Summary of the fitting process (default)
 single_table_obj_exact <- SingleTable.summary(single_table_obj_exact, alpha = 0.05)
 ## Structure of SingleTable object
 str(single_table_obj_exact)
 ## If set alpha level to 0.1
 single_table_obj_exact <- SingleTable.summary(single_table_obj_exact, alpha = 0.1)
 ## If set digit to 2
 single_table_obj_exact <- SingleTable.summary(single_table_obj_exact, digit  = 2)
 ## If decided not to print out
 single_table_obj_exact <- SingleTable.summary(single_table_obj_exact, verbose = FALSE)
 }
}
