% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleTable-methods-exported.R
\name{SingleTable.plot}
\alias{SingleTable.plot}
\title{Plot Method for \code{singletable} objects.}
\usage{
SingleTable.plot(
  single_table_Obj,
  type = "side_by_side",
  xlim = NULL,
  add_vertical = NULL,
  by = "line_type"
)
}
\arguments{
\item{single_table_Obj}{The object inheriting from class \code{singletable}.}

\item{type}{a character string specifying the type of plots to
produce. Options are \code{sidebyside}(default) and \code{overlay}.}

\item{xlim}{a numeric value specifying the lower and upper limits of the x-axis. Default is NULL.}

\item{add_vertical}{a numeric value specifying the x-value for a vertical
reference line at \code{x=addline}. Default is NULL.}

\item{by}{a character string specifying the way to distinguish different plots. Options are \code{line_type}(default) and \code{color}.}
}
\value{
A ggplot2 object is returned.
}
\description{
Produces various plots for single table analysis.
}
\details{
If \code{type="sidebyside"}, the posterior distribution of measure
and the prior distribution are drawn side by side in two plots. If
\code{type="overlay"}, the posterior distribution of measure and
the prior distribution are overlaid in one plot.
}
\examples{
## Assume we have a 2x2 table:{{40,56},{49,60}} and set prior parameters as a1=b1=a2=b2=rho=0.5.
 \donttest{
 library(mmeta)
 library(ggplot2)
 ## If exact method is used, the codes for sampling method are similar.
 ## Create object \code{single_table_obj_exact}
 single_table_obj_exact <- SingleTable.create(a1=0.5,b1=0.5,
 a2=0.5,b2=0.5,rho=0.5, y1=40, n1=96, y2=49, n2=109,model="Sarmanov",measure="OR")
 ## model fit
 single_table_obj_exact <- SingleTable.modelFit(single_table_obj_exact, method = 'exact')
 ## Summary of the fitting process (default)
 single_table_obj_exact <- SingleTable.summary(single_table_obj_exact, alpha = 0.05)
 ## Plot the densities side-by-side
 SingleTable.plot(single_table_obj_exact, type = 'side_by_side')
 ## set xlim between 0 to 4 and add vertical line at x = 1
 SingleTable.plot(single_table_obj_exact, type = 'side_by_side',
 xlim = c(0,4), add_vertical = 1)
 ## override xlab and add title via ggplot2
 plot_obj <- SingleTable.plot(single_table_obj_exact, type = 'side_by_side',
 xlim = c(0,4), add_vertical = 1)
 plot_obj + xlab('Odds ratio') + ggtitle("Plot of density function")
 ## Overlay plot the density
 SingleTable.plot(single_table_obj_exact, type = 'overlay')
 ## Plot by color instead of line type
 SingleTable.plot(single_table_obj_exact, type = 'overlay',by = 'color')
 }
}
