% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy_tensor.R
\name{lazy_shape}
\alias{lazy_shape}
\title{Shape of Lazy Tensor}
\usage{
lazy_shape(x)
}
\arguments{
\item{x}{(\code{\link{lazy_tensor}})\cr
Lazy tensor.}
}
\value{
(\code{integer()} or \code{NULL})
}
\description{
Shape of a lazy tensor. Might be \code{NULL} if the shapes is not known or varying between rows.
Batch dimension is always \code{NA}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lt = as_lazy_tensor(1:10)
lazy_shape(lt)
lt = as_lazy_tensor(matrix(1:10, nrow = 2))
lazy_shape(lt)
\dontshow{\}) # examplesIf}
}
