% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackSetLRScheduler.R
\name{mlr_callback_set.lr_scheduler}
\alias{mlr_callback_set.lr_scheduler}
\alias{CallbackSetLRScheduler}
\title{Learning Rate Scheduling Callback}
\description{
Changes the learning rate based on the schedule specified by a \code{torch::lr_scheduler}.

As of this writing, the following are available:
\itemize{
\item \code{\link[torch:lr_cosine_annealing]{torch::lr_cosine_annealing()}}
\item \code{\link[torch:lr_lambda]{torch::lr_lambda()}}
\item \code{\link[torch:lr_multiplicative]{torch::lr_multiplicative()}}
\item \code{\link[torch:lr_one_cycle]{torch::lr_one_cycle()}}
\item \code{\link[torch:lr_reduce_on_plateau]{torch::lr_reduce_on_plateau()}}
\item \code{\link[torch:lr_step]{torch::lr_step()}}
\item Custom schedulers defined with \code{\link[torch:lr_scheduler]{torch::lr_scheduler()}}.
}
}
\section{Super class}{
\code{\link[mlr3torch:CallbackSet]{mlr3torch::CallbackSet}} -> \code{CallbackSetLRScheduler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{scheduler_fn}}{(\code{lr_scheduler_generator})\cr
The \code{torch} function that creates a learning rate scheduler}

\item{\code{scheduler}}{(\code{LRScheduler})\cr
The learning rate scheduler wrapped by this callback}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CallbackSetLRScheduler-new}{\code{CallbackSetLRScheduler$new()}}
\item \href{#method-CallbackSetLRScheduler-on_begin}{\code{CallbackSetLRScheduler$on_begin()}}
\item \href{#method-CallbackSetLRScheduler-clone}{\code{CallbackSetLRScheduler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="load_state_dict"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-load_state_dict'><code>mlr3torch::CallbackSet$load_state_dict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="print"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-print'><code>mlr3torch::CallbackSet$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="state_dict"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-state_dict'><code>mlr3torch::CallbackSet$state_dict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetLRScheduler-new"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetLRScheduler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetLRScheduler$new(.scheduler, step_on_epoch, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{.scheduler}}{(\code{lr_scheduler_generator})\cr
The \code{torch} scheduler generator (e.g. \code{torch::lr_step}).}

\item{\code{step_on_epoch}}{(\code{logical(1)})\cr
Whether the scheduler steps after every epoch (otherwise every batch).}

\item{\code{...}}{(any)\cr
The scheduler-specific arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetLRScheduler-on_begin"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetLRScheduler-on_begin}{}}}
\subsection{Method \code{on_begin()}}{
Creates the scheduler using the optimizer from the context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetLRScheduler$on_begin()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetLRScheduler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetLRScheduler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetLRScheduler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
