% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_duckdb_backend.R
\name{as_duckdb_backend}
\alias{as_duckdb_backend}
\title{Convert to DuckDB Backend}
\usage{
as_duckdb_backend(data, path = getOption("mlr3db.duckdb_dir", ":temp:"), ...)
}
\arguments{
\item{data}{(\code{data.frame()} | \link[mlr3:DataBackend]{mlr3::DataBackend})\cr
See description.}

\item{path}{(\code{character(1)})\cr
Path for the DuckDB databases.
Either a valid path to a directory which will be created if it not exists, or one of the special strings:
\itemize{
\item \code{":temp:"} (default): Temporary directory of the R session is used, see \code{\link[=tempdir]{tempdir()}}.
Note that this directory will be removed during the shutdown of the R session.
Also note that this usually does not work for parallelization on remote workers.
Set to a custom path instead or use special string \code{":user:"} instead.
\item \code{":user:"}: User cache directory as returned by \code{\link[=R_user_dir]{R_user_dir()}} is used.
}

The default for this argument can be configured via option \code{"mlr3db.sqlite_dir"} or \code{"mlr3db.duckdb_dir"},
respectively. The database files will use the hash of the \link[mlr3:DataBackend]{mlr3::DataBackend} as filename with
file extension \code{".duckdb"} or \code{".sqlite"}.
If the database already exists on the file system, the converters will just established a new read-only
connection.}

\item{...}{(\code{any})\cr
Additional arguments, passed to \link{DataBackendDuckDB}.}
}
\value{
\link{DataBackendDuckDB} or \link[mlr3:Task]{mlr3::Task}.
}
\description{
Converts to a \link{DataBackendDuckDB} using the \CRANpkg{duckdb} database, depending on the input type:
\itemize{
\item \code{data.frame}: Creates a new \link[mlr3:DataBackendDataTable]{mlr3::DataBackendDataTable} first using \code{\link[mlr3:as_data_backend]{mlr3::as_data_backend()}}, then proceeds
with the conversion from \link[mlr3:DataBackendDataTable]{mlr3::DataBackendDataTable} to \link{DataBackendDuckDB}.
\item \link[mlr3:DataBackend]{mlr3::DataBackend}: Creates a new DuckDB data base in the specified path.
The filename is determined by the hash of the \link[mlr3:DataBackend]{mlr3::DataBackend}.
If the file already exists, a connection to the existing database is established and the existing
files are reused.
}

The created backend automatically reconnects to the database if the connection was lost, e.g. because
the object was serialized to the filesystem and restored in a different R session.
The only requirement is that the path does not change and that the path is accessible
on all workers.
}
