% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_metrics.R
\name{metric_types_helper}
\alias{metric_types_helper}
\title{metric_types_helper}
\usage{
metric_types_helper(FUN, y, perf_args)
}
\arguments{
\item{FUN}{A metric function, created with \code{\link[=metric]{metric()}}.}

\item{y}{The outcome vector.}

\item{perf_args}{A list. The arguments to call the metric function with.}
}
\value{
Returns the calculated performance measure.
}
\description{
Prepares the data to be conform with the requirements of
the metrics from \code{mlr3measures}.
}
\details{
The \code{mlr3measures} R package makes some restrictions on the data type of
the ground truth and the predictions, depending on the metric, i.e. the
type of the task (regression or classification).
Thus, it is necessary to convert the inputs to the metric function
accordingly, which is done with this helper function.
}
\examples{
set.seed(123)
ground_truth <- sample(0:1, 100, replace = TRUE)
predictions <- sample(0:1, 100, replace = TRUE)
FUN <- metric("acc")

perf_args <- list(
  ground_truth = ground_truth,
  predictions = predictions
)

metric_types_helper(
  FUN = FUN,
  y = ground_truth,
  perf_args = perf_args
)

}
