% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{plot2compare,Bayes.pred-method}
\alias{plot2compare,Bayes.pred-method}
\title{Comparing plot method plot2compare for three Bayesian prediction class objects}
\usage{
\S4method{plot2compare}{Bayes.pred}(x, y, z, newwindow = FALSE,
  plot.legend = TRUE, names, ylim, xlab = "times", ylab = "X", ...)
}
\arguments{
\item{x}{Bayes.pred class}

\item{y}{Bayes.pred class}

\item{z}{Bayes.pred class (optional)}

\item{newwindow}{logical(1), if TRUE, a new window is opened for the plot}

\item{plot.legend}{logical(1), if TRUE, a legend is added}

\item{names}{character vector with names for the three objects appearing in the legend}

\item{ylim}{optional}

\item{xlab}{optional, default 'times'}

\item{ylab}{optional, default 'X'}

\item{...}{optional plot parameters}
}
\description{
Comparison of the results for up to three S4 class Bayes.pred objects
}
\examples{
random <- 1; sigma <- 0.1; fixed <- 5; param <- c(3, 0.5)
sim <- mixedsde.sim(M = 20, T = 1, N = 50, model = 'OU', random = random, fixed = fixed,
       density.phi = 'normal',param= param, sigma= sigma, X0 = 0, op.plot = 1)

# here: only 100 iterations for example - should be much more!
estim_Bayes_withoutprior <- mixedsde.fit(times = sim$times, X = sim$X, model = 'OU',
             random, estim.method = 'paramBayes',  nMCMC = 100)
prior <- list( m = c(param[1], fixed), v = c(param[1], fixed), alpha.omega = 11,
            beta.omega = param[2]^2*10, alpha.sigma = 10, beta.sigma = sigma^2*9)
estim_Bayes <- mixedsde.fit(times = sim$times, X = sim$X, model = 'OU', random,
           estim.method = 'paramBayes', prior = prior, nMCMC = 100)
plot2compare(estim_Bayes, estim_Bayes_withoutprior, names = c('with prior', 'without prior'))
}
\references{
Dion, C., Hermann, S. and Samson, A. (2016). Mixedsde: an R package to fit mixed stochastic differential equations.
}

