% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnormpar.R
\name{to_mu_sd_lnorm}
\alias{to_mu_sd_lnorm}
\title{Parameter Conversion for Lognormal Distribution}
\usage{
to_mu_sd_lnorm(mulog, sdlog)
}
\arguments{
\item{mulog}{a vector of logarithm means of lognormal distributions}

\item{sdlog}{a vector of logarithm standard deviations of lognormal distributions}
}
\value{
a list of two items
\item{mu}{a vector of the means of lognormal distributions}
\item{sd}{a vector of the standard deviations of lognormal distributions}
}
\description{
The function \code{to_mu_sd_lnorm} converts the logarithm mean and logarithm standard deviation to the
mean and standard deviation
}
\details{
The purpose of this function is to convert the parameterization of lognormal distribution in the
form of logarithm mean and logarithm standard deviation to the form of mean and standard deviation.
}
\examples{
to_mu_sd_lnorm(2, 1)
to_mu_sd_lnorm(c(2, 4), c(1, 1))

}
\seealso{
\code{\link{to_mulog_sdlog_lnorm}}
}
