% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstab.R
\name{crosstab}
\alias{crosstab}
\title{Cross Tabulation}
\usage{
crosstab(x, print = c("no", "all", "row", "col", "total"), freq = TRUE,
         split = FALSE, na.omit = TRUE, digits = 2, as.na = NULL,
         check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a matrix or data frame with two or three columns.}

\item{print}{a character string or character vector indicating which percentage(s) to be printed on the
consolue, i.e., no percentages (\code{"no"}) (default), all percentages (\code{"all"}),
row-wise percentages (\code{"row"}), column-wise percentages (\code{"col"}), and
total percentages (\code{"total"}).}

\item{freq}{logical: if \code{TRUE}, absolute frequencies will be included in the cross tabulation.}

\item{split}{logical: if \code{TRUE}, output table is split in absolute frequencies and percentage(s).}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion).}

\item{digits}{an integer indicating the number of decimal places digits to be used for displaying percentages.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is printed on the console.}
}
\value{
Returns an object of class \code{crosstab}, which is a list with following entries: function call (\code{call}),
matrix or data frame specified in \code{x} (\code{data}), specification of function arguments (\code{args}), and
list with results (\code{result}).
}
\description{
This function creates a two-way and three-way cross tabulation with absolute frequencies and row-wise, column-wise
and total percentages.
}
\examples{
dat <- data.frame(x1 = c(1, 2, 2, 1, 1, 2, 2, 1, 1, 2),
                  x2 = c(1, 2, 2, 1, 2, 1, 1, 1, 2, 1),
                  x3 = c(-99, 2, 1, 1, 1, 2, 2, 2, 2, 1))

# Cross Tabulation for x1 and x2
crosstab(dat[, c("x1", "x2")])

# Cross Tabulation for x1 and x2
# print all percentages
crosstab(dat[, c("x1", "x2")], print = "all")

# Cross Tabulation for x1 and x2
# print row-wise percentages
crosstab(dat[, c("x1", "x2")], print = "row")

# Cross Tabulation for x1 and x2
# print col-wise percentages
crosstab(dat[, c("x1", "x2")], print = "col")

# Cross Tabulation x1 and x2
# print total percentages
crosstab(dat[, c("x1", "x2")], print = "total")

# Cross Tabulation for x1 and x2
# print all percentages, split output table
crosstab(dat[, c("x1", "x2")], print = "all", split = TRUE)

# Cross Tabulation for x1 and x3
# do not apply listwise deletion, convert value -99 to NA
crosstab(dat[, c("x1", "x3")], na.omit = FALSE, as.na = -99)

# Cross Tabulation for x1 and x3
# print all percentages, do not apply listwise deletion, convert value -99 to NA
crosstab(dat[, c("x1", "x3")], print = "all", na.omit = FALSE, as.na = -99)

# Cross Tabulation for x1, x2, and x3
crosstab(dat[, c("x1", "x2", "x3")])

# Cross Tabulation for x1, x2, and x3
# print all percentages
crosstab(dat[, c("x1", "x2", "x3")], print = "all")

# Cross Tabulation for x1, x2, and x3
# print all percentages,  split output table
crosstab(dat[, c("x1", "x2", "x3")], print = "all", split = TRUE)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}

\code{\link{freq}}, \code{\link{descript}}, \code{\link{multilevel.descript}},
\code{\link{na.descript}}.
}
