% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{md.eval}
\alias{md.eval}
\title{md.eval}
\usage{
md.eval(name, eval, center = Inf, invisible = FALSE)
}
\arguments{
\item{name}{name of the covariate}

\item{eval}{string specifying the formula to calculate the covariate}

\item{center}{expected value of the calculated covariate}

\item{invisible}{specifies whether the calculated covariate is included in the simulated dataset}
}
\description{
Creates information of a covariate that is calculated (from other covariates) by evaluating a specified formula.
This function call must be added to the \code{\link{md.simparams}} object.
}
\examples{

\dontrun{
library(missDeaths)

sim = md.simparams() +
    md.uniform("birth", as.Date("1915-1-1"), as.Date("1930-1-1")) +
      md.uniform("start", as.Date("2000-1-1"), as.Date("2005-1-1")) +
          md.eval("age", "as.numeric(start - birth)/365.2425", 80, FALSE)
}
}
