% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{call_mirai}
\alias{call_mirai}
\alias{call_mirai_}
\title{mirai (Call Value)}
\usage{
call_mirai(aio)

call_mirai_(aio)
}
\arguments{
\item{aio}{a \sQuote{mirai} object.}
}
\value{
The passed \sQuote{mirai} (invisibly). The retrieved value is stored
    at \code{$data}.
}
\description{
\code{call_mirai} retrieves the value of a \sQuote{mirai}, waiting for the
    asynchronous operation to resolve if it is still in progress.

\code{call_mirai_} is a variant that allows user interrupts, suitable for
    interactive use.
}
\details{
This function will wait for the async operation to complete if still
    in progress (blocking).

    The \sQuote{mirai} updates itself in place, so to access the value of a
    \sQuote{mirai} \code{x} directly, use \code{call_mirai(x)$data}.
}
\section{Alternatively}{


    The value of a \sQuote{mirai} may be accessed at any time at
    \code{$data}, and if yet to resolve, an \sQuote{unresolved} logical NA
    will be returned instead.

    Using \code{\link{unresolved}} on a \sQuote{mirai} returns TRUE only if
    it has yet to resolve and FALSE otherwise. This is suitable for use in
    control flow statements such as \code{while} or \code{if}.
}

\section{Errors}{


    If an error occurs in evaluation, the error message is returned as a
    character string of class \sQuote{miraiError} and \sQuote{errorValue}
    (the stack trace is available at \code{$stack.trace} on the error
    object). \code{\link{is_mirai_error}} may be used to test for this.

    \code{\link{is_error_value}} tests for all error conditions including
    \sQuote{mirai} errors, interrupts, and timeouts.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

# using call_mirai()
df1 <- data.frame(a = 1, b = 2)
df2 <- data.frame(a = 3, b = 1)
m <- mirai(as.matrix(rbind(df1, df2)), df1 = df1, df2 = df2, .timeout = 1000)
call_mirai(m)$data

# using unresolved()
m <- mirai(
  {
    res <- rnorm(n)
    res / rev(res)
  },
  n = 1e6
)
while (unresolved(m)) {
  cat("unresolved\n")
  Sys.sleep(0.1)
}
str(m$data)

}

}
