% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoichiometricMatrix.R
\name{stoichiometricMatrix}
\alias{stoichiometricMatrix}
\title{Build the stoichiometric matrix for a set of stoichiometric reactions}
\usage{
stoichiometricMatrix(reactionList)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following characteristics: \itemize{
\item Arrows symbols must be given in the form \code{'=>'} or \code{'<=>'}
\item Inverse arrow symbols \code{'<='} or other types as: \code{'-->'}, \code{'<==>'}, \code{'->'} will not be parsed and will lead to errors.
\item Arrow symbols and plus signs (\code{+}) must be surrounded by a space character
\item Stoichiometric coefficients must be surrounded by a space character and not by parentheses.
\item Each metabolite must have only one stoichiometric coefficient, substituents must be joined to metabolite name by a hyphen (\code{-}) symbol.
\item Exchange reactions have only one metabolite before arrow symbol
\item Compartments must be given between square brackets ([compartment]) joined at the end of metabolite name
}
Some examples of valid stoichiometric reactions are: \itemize{
\item \code{H2O[c] + Urea-1-Carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]}
\item \code{ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]}
\item \code{CO2[c] <=> }
}}
}
\value{
The stoichiometric matrix for a given set of stoichiometric reactions
}
\description{
A set of stoichiometric reactions is often represented in a more compact form called the stoichiometry matrix. 
If a metabolic network has n reactions and m participating metabolites, then the stoichiometry matrix will have correspondingly m rows and n columns. 
Values in the stoichiometric matrix represent the metabolites coefficients in each reaction.
}
\examples{
# Loading a set of stoichiometric reactions
glycolysis <- read.csv(system.file("extdata/glycolysisModel.csv",package = "minval"), sep='\\t')

# Building the stoichiometric matrix
stoichiometricMatrix(reactionList = glycolysis$REACTION)
}
\author{
Daniel Camilo Osorio <dcosorioh@tamu.edu>
}
