% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_intensity.R
\name{index_intensity}
\alias{index_intensity}
\title{Summary indices of migration intensity}
\source{
Bell, M., Blake, M., Boyle, P., Duke-Williams, O., Rees, P. H., Stillwell, J., & Hugo, G. J. (2002). Cross-national comparison of internal migration: issues and measures. Journal of the Royal Statistical Society: Series A (Statistics in Society), 165(3), 435–464. https://doi.org/10.1111/1467-985X.00247

Courgeau, D. (1973). Migrants et migrations. Population, 28(1), 95–129. https://doi.org/10.2307/1530972

Bernard, A., Rowe, F., Bell, M., Ueffing, P., Charles-Edwards, E., & Zhu, Y. (2017). Comparing internal migration across the countries of Latin America: A multidimensional approach. Plos One, 12(3), e0173895. https://doi.org/10.1371/journal.pone.0173895
}
\usage{
index_intensity(mig_total = NULL, pop_total = NULL, n = NULL, long = TRUE)
}
\arguments{
\item{mig_total}{Numeric value for the total number of migrations.}

\item{pop_total}{Numeric value for the total population.}

\item{n}{Numeric value for the number of regions used in the definition of migration for \code{mig_total}.}

\item{long}{Logical to return a long data frame with index values all in one column}
}
\value{
A tibble with 2 summary measures where
\item{cmp}{Crude migration probability from Bell et. al. (2002), sometimes known as crude migration intensity, e.g. Bernard (2017)}
\item{courgeau_k}{Intensity measure of Courgeau (1973)}
}
\description{
Summary indices of migration intensity
}
\examples{
# single year
library(dplyr)
m <- korea_gravity \%>\%
  filter(year == 2020,
         orig != dest)
m
p <- korea_gravity \%>\%
  filter(year == 2020) \%>\%
  distinct(dest, dest_pop)
p
index_intensity(mig_total = sum(m$flow), pop_total = sum(p$dest_pop*1e6), n = nrow(p))

# multiple years
library(tidyr)
library(purrr) 
mm <- korea_gravity  \%>\%
 filter(orig != dest) \%>\%
  group_by(year) \%>\%
  summarise(m = sum(flow))
mm

pp <- korea_gravity \%>\%
  group_by(year) \%>\%
  distinct(dest, dest_pop) \%>\%
  summarise(p = sum(dest_pop)*1e6,
            n = n_distinct(dest))
pp

library(purrr)
library(tidyr)
mm \%>\%
  left_join(pp) \%>\%
  mutate(i = pmap(
    .l = list(m, p, n),
    .f = ~index_intensity(mig_total = ..1, pop_total = ..2,n = ..3, long = FALSE)
  )) \%>\%
  unnest(cols = i)
}
