\name{mfdb_aggregate_group}
\alias{mfdb_group}
\alias{mfdb_timestep_yearly}
\alias{mfdb_timestep_biannually}
\alias{mfdb_timestep_quarterly}
\alias{mfdb_group_numbered}
\alias{mfdb_bootstrap_group}

\title{MareFrame DB groups}
\description{
    Represent a grouping of data to be applied when summarising area, timestep,
    age or length.
}

\usage{
# Named grouping of discrete items
mfdb_group(...)

# Pre-baked mfdb_groups for timesteps
mfdb_timestep_yearly
mfdb_timestep_biannually
mfdb_timestep_quarterly

# Grouping of discrete items, names generated by prefix
mfdb_group_numbered(prefix, ...)

# make (count) mfdb_groups, by sampling (count) times from (group)
mfdb_bootstrap_group(count, group, seed = NULL)
}
\arguments{
    \item{...}{
        For \code{mfdb_group}, all named arguments are expected to be a named
        list of members for that group.
        For \code{mfdb_group_numbered}, the members do not have to be named, a
        name will be generated based on the prefix.
    }
    \item{prefix}{
        When generating numeric group names, the character prefix to append to
        the beginning.
    }
    \item{group}{
        For \code{mfdb_bootstrap_group}, the mfdb_group to do sampling with
        replacement from.
    }
    \item{count}{
        For \code{mfdb_bootstrap_group}, how many times to sample each member
        of the given group.
    }
    \item{seed}{
        For \code{mfdb_bootstrap_group}, if you want your groups to remain
        consistent across sessions, then specify a random integer as per RNG.
    }
}

\value{
An \code{mfdb_aggregate} object that can then be used in querying functions
such as \code{mfdb_sample_count}
}

\examples{
## Aggregate age into 2 groups. "young" (for ages 1--3) and
## "old" (for ages 4--6)
g1 <- mfdb_group(young = c(1,2,3), old = c(4,5,6))

## Aggregate areas into "area1" and "area2".
g2 <- mfdb_group_numbered("area", c(1011,1012,1013), c(1021,1022))

## Take 3 samples with replacement from each group in area
g3 <- mfdb_bootstrap_group(3, g2)
}
