% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable.R
\name{lifetable.matrix}
\alias{lifetable.matrix}
\alias{lifetable}
\alias{lifetable.formula}
\title{Life table}
\usage{
\method{lifetable}{matrix}(x, strata = list(), breaks = c(),
   weights=NULL, confint = FALSE, ...)

 \method{lifetable}{formula}(x, data=parent.frame(), breaks = c(),
   weights=NULL, confint = FALSE, ...)
}
\arguments{
\item{x}{time formula (Surv) or matrix/data.frame with columns time,status or entry,exit,status}

\item{strata}{strata}

\item{breaks}{time intervals}

\item{weights}{weights variable}

\item{confint}{if TRUE 95\% confidence limits are calculated}

\item{...}{additional arguments to lower level functions}

\item{data}{data.frame}
}
\description{
Create simple life table
}
\examples{
library(timereg)
data(TRACE)

d <- with(TRACE,lifetable(Surv(time,status==9)~sex+vf,breaks=c(0,0.2,0.5,8.5)))
lava::estimate(glm(events ~ offset(log(atrisk))+factor(int.end)*vf + sex*vf,
            data=d,poisson))
}
\author{
Klaus K. Holst
}
