% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimfill.rm5.R
\name{trimfill.rm5}
\alias{trimfill.rm5}
\alias{trimfill.cdir}
\alias{print.trimfill.rm5}
\alias{print.trimfill.cdir}
\title{Cochrane review: trim-and-fill method}
\usage{
\method{trimfill}{rm5}(x, comp.no, outcome.no, ...)

\method{trimfill}{cdir}(x, comp.no, outcome.no, ...)

\method{print}{trimfill.rm5}(x, ...)

\method{print}{trimfill.cdir}(x, ...)
}
\arguments{
\item{x}{An object of class \code{rm5}, \code{trimfill.rm5},
\code{cdir} or \code{trimfill.cdir}.}

\item{comp.no}{Comparison number.}

\item{outcome.no}{Outcome number.}

\item{...}{Additional arguments (passed on to \code{metacr}).}
}
\description{
Conduct trim-and-fill analysis for all meta-analyses in a Cochrane
review.
}
\details{
This function can be used to conduct a trim-and-fill analysis for
all or selected meta-analyses in a Cochrane review of intervention
studies (Higgins et al., 2023).

The R function \code{\link{metacr}} is called internally.
}
\examples{
# Locate export data file "Fleiss1993_CR.csv"
# in sub-directory of package "meta"
#
filename <- system.file("extdata", "Fleiss1993_CR.csv", package = "meta")
Fleiss1993_CR <- read.rm5(filename)

# Conduct trim-and-fill analysis
#
trimfill(Fleiss1993_CR)

# Conduct trim-and-fill analysis only for second outcome of first
# comparison
#
trimfill(Fleiss1993_CR, comp.no = 1, outcome.no = 2)

}
\references{
Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch
VA (editors) (2023):
\emph{Cochrane Handbook for Systematic Reviews of Interventions
  Version 6.4 (updated August 2023)}.
Available from \url{https://www.cochrane.org/authors/handbooks-and-manuals/handbook}
}
\seealso{
\code{\link{summary.meta}}, \code{\link{metacr}},
  \code{\link{read.rm5}}, \code{\link{read.cdir}},
  \code{\link{metabias.rm5}}, \code{\link{metabias.cdir}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
