% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.meta.R
\name{summary.meta}
\alias{summary.meta}
\title{Summary of meta-analysis results}
\usage{
\method{summary}{meta}(object, ...)
}
\arguments{
\item{object}{An object of class \code{meta}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An object of classes \code{summary.meta} and \code{meta} (see
\code{\link{meta-object}}.
}
\description{
Summary method for objects of class \code{meta}.
}
\details{
Summary method for objects of class \code{meta}.
}
\examples{
data(Fleiss1993cont)
m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, studlab = paste(study, year), sm = "SMD")
summary(m1)

summary(update(m1, subgroup = c(1, 2, 1, 1, 2), subgroup.name = "group"))
forest(update(m1, subgroup = c(1, 2, 1, 1, 2), subgroup.name = "group"))

\dontrun{
# Use unicode characters to print tau^2, tau, and I^2
print(summary(m1),
  text.tau2 = "\u03c4\u00b2", text.tau = "\u03c4", text.I2 = "I\u00b2")
}

}
\references{
Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation

Crippa A, Khudyakov P, Wang M, Orsini N, Spiegelman D (2016):
A new measure of between-studies heterogeneity in meta-analysis.
\emph{Statistics in Medicine},
\bold{35}, 3661--75

Higgins JPT & Thompson SG (2002):
Quantifying heterogeneity in a meta-analysis.
\emph{Statistics in Medicine},
\bold{21}, 1539--58
}
\seealso{
\code{\link{print.summary.meta}}, \code{\link{metabin}},
  \code{\link{metacont}}, \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
