% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/summary-methods.R
\name{summary}
\alias{summary}
\alias{summary,LM-method}
\alias{summary,GLM-method}
\alias{summary,QGLM-method}
\title{Summary methods}
\usage{
\S4method{summary}{LM}(object, ...)

\S4method{summary}{GLM}(object, ...)

\S4method{summary}{QGLM}(object, ...)
}
\arguments{
\item{object}{An object to be summarized.}

\item{...}{Further arguments passed to methods.}
}
\description{
Provides summary methods for objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{summary(LM)}: Summarizes the results of the overall model test and the
significance tests for coefficients.

\item \code{summary(GLM)}: Summarizes the results of the overall model test and the
significance tests for coefficients. The dispersion parameter is extracted
for display.

\item \code{summary(QGLM)}: Summarizes the results of the overall model test and the
significance tests for coefficients. The estimated dispersion parameter is
extracted for display.

}}
\examples{
data("mtcars")
fit <- el_lm(mpg ~ wt, data = mtcars)
summary(fit)
}
