% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/elmt-methods.R
\name{elmt}
\alias{elmt}
\alias{elmt,EL-method}
\title{Empirical likelihood multiple tests}
\usage{
\S4method{elmt}{EL}(object, rhs = NULL, lhs = NULL, alpha = 0.05, control = NULL)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL}.}

\item{rhs}{A numeric vector (column matrix) or a list of numeric vectors for
the right-hand sides of hypotheses. Defaults to \code{NULL}. See ‘Details’.}

\item{lhs}{A list or a numeric matrix for the left-hand sides of hypotheses.
For a list \code{lhs}, each element must be specified as a single instance of
the \code{lhs} in \code{\link[=elt]{elt()}}. For a matrix \code{lhs}, each row gives a linear
combination of the parameters in \code{object}. The number of columns must be
equal to the number of parameters. Defaults to \code{NULL}. See ‘Details’.}

\item{alpha}{A single numeric for the overall significance level. Defaults to
\code{0.05}.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}. Defaults to \code{NULL} and inherits the \code{control} slot in
\code{object}.}
}
\value{
An object of class of \linkS4class{ELMT}.
}
\description{
Tests multiple linear hypotheses simultaneously.
}
\details{
\code{\link[=elmt]{elmt()}} tests multiple hypotheses simultaneously. Each hypothesis
corresponds to the constrained empirical likelihood ratio described in
\linkS4class{CEL}. \code{rhs} and \code{lhs} cannot be both \code{NULL}. The right-hand
side and left-hand side of each hypothesis must be specified as described
in \code{\link[=elt]{elt()}}.

For specifying linear contrasts more conveniently, \code{rhs} and \code{lhs} also
take a numeric vector and a numeric matrix, respectively. Each element of
\code{rhs} and each row of \code{lhs} correspond to a contrast (hypothesis).

The vector of empirical likelihood ratio statistics asymptotically follows
a multivariate chi-square distribution under the complete null hypothesis.
The multiple testing procedure asymptotically controls the family-wise
error rate at the level \code{alpha}. Based on the distribution of the maximum
of the test statistics, the adjusted p-values are estimated by Monte Carlo
simulation.
}
\examples{
## Bivariate mean (list `rhs` & no `lhs`)
set.seed(143)
data("women")
fit <- el_mean(women, par = c(65, 135))
rhs <- list(c(64, 133), c(66, 140))
elmt(fit, rhs = rhs)

## Pairwise comparison (no `rhs` & list `lhs`)
data("clothianidin")
fit2 <- el_lm(clo ~ -1 + trt, clothianidin)
lhs2 <- list(
  "trtNaked - trtFungicide",
  "trtFungicide - trtLow",
  "trtLow - trtHigh"
)
elmt(fit2, lhs = lhs2)

## Arbitrary hypotheses (list `rhs` & list `lhs`)
data("mtcars")
fit3 <- el_lm(mpg ~ wt + qsec, data = mtcars)
lhs3 <- list(c(1, 4, 0), rbind(c(0, 1, 0), c(0, 0, 1)))
rhs3 <- list(0, c(-6, 1))
elmt(fit3, rhs = rhs3, lhs = lhs3)
}
\references{
Kim E, MacEachern SN, Peruggia M (2023).
``Empirical likelihood for the analysis of experimental designs.''
\emph{Journal of Nonparametric Statistics}, \strong{35}(4), 709--732.
\doi{10.1080/10485252.2023.2206919}.

Kim E, MacEachern SN, Peruggia M (2024).
``melt: Multiple Empirical Likelihood Tests in R.''
\emph{Journal of Statistical Software}, \strong{108}(5), 1--33.
\doi{10.18637/jss.v108.i05}.
}
\seealso{
\linkS4class{EL}, \linkS4class{ELMT}, \code{\link[=elt]{elt()}}, \code{\link[=el_control]{el_control()}}
}
