% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_watershed_control.R
\name{default_watershed_control}
\alias{default_watershed_control}
\title{Default control parameters for watershed processes}
\usage{
default_watershed_control(watershed_model = "tetis")
}
\arguments{
\item{watershed_model}{Hydrological model for watershed processes. Only "tetis" or "serghei" are accepted.}
}
\value{
A list with the following items:
\itemize{
\item{\code{watershed_model}: A string with the watershed model.}
\item{\code{weather_aggregation_factor [= 1]}: An integer specifying the spatial aggregation for interpolated weather.}
\item{\code{tetis_parameters}: A list of TETIS parameters with the following elements:
\itemize{
\item{\code{R_localflow [= 1.0]}: Correction factor for soil hydraulic saturated conductivity (local vertical flows).}
\item{\code{R_interflow [= 50.0]}: Correction factor for soil hydraulic saturated conductivity (subsurface flow between grid cells).}
\item{\code{R_baseflow [= 5.0]}: Correction factor for bedrock hydraulic conductivity (groundwaterflow between grid cells).}
\item{\code{n_interflow [= 1.0]}: Exponent for the determination of interflow.}
\item{\code{n_baseflow [= 1.0]}: Exponent for the determination of baseflow.}
\item{\code{num_daily_substeps [= 4]}: Number of daily sub-steps for interflow calculations.}
\item{\code{subwatersheds [= FALSE]}: A boolean flag to define watershed subunits.}
\item{\code{max_overlap [= 0.2]}: Maximum proportion of overlapping cells for watershed subunits to be considered independent. Lower values will normally produce larger subunits.}
\item{\code{rock_max_infiltration [= 10]}: Maximum infiltration rate (mm·day-1) for rock cells.}
\item{\code{deep_aquifer_loss [= 0]}: Daily loss rate from watershed aquifer towards a deeper aquifer not connected to outlets (mm·day-1).}
\item{\code{n_manning [= 0.035]}: Manning's roughness coefficient.}
}
}
\item{\code{serghei_parameters}: A list of SERGHEI parameters with the following elements:
\itemize{
\item{\code{input_dir [= ""]}: Path to SERGHEI input files.}
\item{\code{output_dir [= ""]}: Path to SERGHEI output files.}
\item{\code{force_equal_layer_widths [= FALSE]}: A boolean flag to force equal layer widths (taken from the first soil element) in all soils.}
}
}
}
}
\description{
Defines default control parameters for watershed processes
}
\examples{
default_watershed_control()

}
\seealso{
\code{\link{spwb_land}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
