% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_nodes.R
\name{mark_select}
\alias{mark_select}
\alias{node_is_random}
\alias{node_is_max}
\alias{node_is_min}
\title{Marking nodes for selection based on measures}
\usage{
node_is_random(.data, size = 1)

node_is_max(node_measure, ranks = 1)

node_is_min(node_measure, ranks = 1)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{size}{The number of nodes to select (as TRUE).}

\item{node_measure}{An object created by a \code{node_} measure.}

\item{ranks}{The number of ranks of max or min to return.
For example, \code{ranks = 3} will return TRUE for nodes with
scores equal to any of the top (or, for \code{node_is_min()}, bottom)
three scores.
By default, \code{ranks = 1}.}
}
\description{
These functions return logical vectors the length of the
nodes in a network identifying which hold certain properties or positions in the network.
\itemize{
\item \code{node_is_random()} marks one or more nodes at random.
\item \code{node_is_max()} and \code{node_is_min()} are more generally useful
for converting the results from some node measure into a mark-class object.
They can be particularly useful for highlighting which node or nodes
are key because they minimise or, more often, maximise some measure.
}
}
\examples{
node_is_random(ison_brandes, 2)
#node_is_max(migraph::node_degree(ison_brandes))
#node_is_min(migraph::node_degree(ison_brandes))
}
\seealso{
Other marks: 
\code{\link{mark_diff}},
\code{\link{mark_nodes}},
\code{\link{mark_tie_select}},
\code{\link{mark_ties}},
\code{\link{mark_triangles}}
}
\concept{marks}
