% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_indirect_paths.R
\name{all_indirect_paths}
\alias{all_indirect_paths}
\alias{all_paths_to_df}
\title{Enumerate All Indirect Effects in a Model}
\usage{
all_indirect_paths(
  fit = NULL,
  exclude = NULL,
  x = NULL,
  y = NULL,
  group = NULL
)

all_paths_to_df(all_paths)
}
\arguments{
\item{fit}{A fit object. It can be the output of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrapper such as \code{\link[lavaan:sem]{lavaan::sem()}},
or a list of the output of \code{\link[=lm]{lm()}} or the output of
\code{\link[=lm2list]{lm2list()}}.
If it is a single model fitted by
\code{\link[=lm]{lm()}}, it will be automatically converted
to a list by \code{\link[=lm2list]{lm2list()}}.}

\item{exclude}{A character vector of variables to be excluded
in the search, such as control variables.}

\item{x}{A character vector of variables that will be
included as the \code{x} variables. If supplied, only
paths that start from these variables will be included
in the search.
If \code{NULL}, the default, then all variables that are
one of the predictors in at least one regression
equation will be
included in the search.}

\item{y}{A character vector of variables that will be
included as the \code{y} variables. If supplied, only
paths that start from these variables will be included
in the search.
If \code{NULL}, the default, then all variables that are
the outcome variables in at least one regression
equation will be
included in the search.}

\item{group}{Either the group number
as appeared in the \code{\link[=summary]{summary()}}
or \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
output of a \link[lavaan:lavaan-class]{lavaan::lavaan} object,
or the group label as used in
the \link[lavaan:lavaan-class]{lavaan::lavaan} object.
Used only when the number of
groups is greater than one. Default
is \code{NULL}. If not specified by the model
has more than one group, than paths
that appears in at least one group
will be included in the output.}

\item{all_paths}{An \code{all_paths}-class object. For example,
the output of \code{\link[=all_indirect_paths]{all_indirect_paths()}}.}
}
\value{
\code{\link[=all_indirect_paths]{all_indirect_paths()}} returns
a list of the class \code{all_paths}. Each argument is a
list of three character vectors,
\code{x}, the name of the predictor that starts a path, \code{y},
the name of the outcome that ends a path, and \code{m}, a
character vector of one or more names of the mediators,
from \code{x} to \code{y}. This class has a print method.

\code{\link[=all_paths_to_df]{all_paths_to_df()}} returns a data frame with three
columns, \code{x}, \code{y}, and \code{m}, which can be used by
functions such as \code{\link[=indirect_effect]{indirect_effect()}}.
}
\description{
Check all indirect paths in a model and
return them as a list of arguments of \code{x}, \code{y},
and \code{m}, to be used by \code{indirect_effect()}.
}
\details{
It makes use of \code{\link[igraph:all_simple_paths]{igraph::all_simple_paths()}}
to identify paths in a model.
\subsection{Multigroup Models}{

Since Version 0.1.14.2, support for
multigroup models has been added for models
fitted by \code{lavaan}. If a model has more
than one group and \code{group} is not
specified, than paths in all groups
will be returned. If \code{group} is
specified, than only paths in the
selected group will be returned.
}
}
\section{Functions}{
\itemize{
\item \code{all_indirect_paths()}: Enumerate all indirect paths.

\item \code{all_paths_to_df()}: Convert the output of
\code{\link[=all_indirect_paths]{all_indirect_paths()}} to a data frame with
three columns: \code{x}, \code{y}, and \code{m}.

}}
\examples{
library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)
# All indirect paths
out1 <- all_indirect_paths(fit)
out1
names(out1)

# Exclude c1 and c2 in the search
out2 <- all_indirect_paths(fit, exclude = c("c1", "c2"))
out2
names(out2)

# Exclude c1 and c2, and only consider paths start
# from x and end at y
out3 <- all_indirect_paths(fit, exclude = c("c1", "c2"),
                           x = "x",
                           y = "y")
out3
names(out3)

# Multigroup models

data(data_med_complicated_mg)
mod <-
"
m11 ~ x1 + x2 + c1 + c2
m12 ~ m11 + c1 + c2
m2 ~ x1 + x2 + c1 + c2
y1 ~ m11 + m12 + x1 + x2 + c1 + c2
y2 ~ m2 + x1 + x2 + c1 + c2
"
fit <- sem(mod, data_med_complicated_mg, group = "group")
summary(fit)

all_indirect_paths(fit,
                   x = "x1",
                   y = "y1")
all_indirect_paths(fit,
                   x = "x1",
                   y = "y1",
                   group = 1)
all_indirect_paths(fit,
                   x = "x1",
                   y = "y1",
                   group = "Group B")

}
\seealso{
\code{\link[=indirect_effect]{indirect_effect()}}, \code{\link[=lm2list]{lm2list()}}.
\code{\link[=many_indirect_effects]{many_indirect_effects()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
