% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-special.R
\name{updateFromDF}
\alias{updateFromDF}
\title{Easier to use wrapper of \code{\link{updateValues}}}
\usage{
updateFromDF(
  target,
  projectName,
  modelName,
  df,
  autolink = FALSE,
  dryRun = FALSE,
  separator = ",",
  auto.proceed = FALSE,
  revisions.only = FALSE,
  ...
)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{modelName}{Single string. The name of the subset data structure within the project, which are referred to as 'model's in magma, to interact with.
For options, see \code{\link{retrieveModels}} or https://timur.ucsf.edu/<projectName>/map.}

\item{df}{A dataframe, containing the data to upload to magma.

Alternatively, a String specifying the file path of a file containing such data.

See below for additional formatting details.}

\item{autolink}{Logical. FALSE by default for safety, but often you will want to set it to TRUE. Passed through to magma, this parameter controls whether the system will attempt to connect all targeted records up with the project's root.
Specifically, this means the system will 
1) determine parent records of all targeted records if it can, based on the project's gnomon grammar, 
2) continue parent determination for those parent records, repeating this process until reaching the project's root (the project record),
then 3) creates any of these records that don't currently exist,
and finally 4) creates all the assumed parent-child linkages}

\item{dryRun}{Logical. FALSE by default. Passed through to magma, this parameter controls whether the system will only test whether the update is valid without making changes to the database.}

\item{separator}{String indicating the field separator to use if providing \code{df} as a file path.
Default = \code{","}.
Use \code{"\t"} for tsvs.}

\item{auto.proceed}{Logical. When set to TRUE, the function does not ask before proceeding forward with the 'magma/update'.}

\item{revisions.only}{Logical. For troubleshooting purposes, when set to \code{TRUE}, no data will be sent to magma.
Instead, the list structure that would have been passed to the \code{revisions} input of \code{\link{updateValues}} is returned as output.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}
}
\value{
None directly.

The function sends data to magma, and the only outputs are information reported via the console.
}
\description{
A wrapper of \code{\link{updateValues}} which takes in updates in the form of a dataframe, csv, tsv, with rows = records and columns = attributes.
}
\details{
This function provides a simple method for updating multiple attributes of multiple magma records provided as a rectangular dataframe, or equivalent file structure.
It utilizes the magma/query function, documented here \url{https://mountetna.github.io/magma.html#update},
to upload data after converting to the format required by that function.

Upload targets the \code{df}'s row-indicated records and column-indicated attributes of the \code{modelName} model of \code{projectName} project.

\code{df} data are provided either as a dataframe, or file path which points toward such data.
If given as a file path, the \code{separator} input can be used to adjust for whether the file is a csv (the default, \code{separator = ","}), or tsv, \code{separator = "\t"}, or other format.

The data structure:
\itemize{
\item Rows = records, with the first column indicating the record identifiers.
\item Columns = represent the data desired to be given for each attribute.
\item Column Names (or the top row when providing a file) = attribute names.
Except for the first column (ignored as this column's data are used as identifiers), all column names must be valid attribute names of the target \code{modelName}.
}

This data is read in, presented to the user for inspection, then transformed to the necessary format and passed along to \code{\link{updateValues}}.

The \code{updateValues()} function will then summarize records to be updated and allow the user to double-check this information before proceeding.

This user-prompt step can be bypassed (useful when running in a non-interactive way) by setting \code{auto.proceed = TRUE}, but NOTE:
It is a good idea to always check carefully before proceeding, if possible.
Data can be overwritten with NAs or zeros or the like, but improperly named records cannot be easily removed.
}
\section{Use Case. Using this function to change records' identifiers}{


To do so, provide a file or dataframe where
1) The first column, named something random Iits name will be ignored.), contains current identifiers;
2) Some other column, named as the attribute which is treated as the identifier for the model, contains the new identifiers

To determine the identifier attribute's name, you can use \code{\link{retrieveTemplate}}:

\code{retrieveTemplate(<target>, <projectName>)$models$<modelName>$template$identifier}.
}

\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    ### Note that you likely do not have write-permissions for the 'example'
    # project, so this code can be expected to give an authorization error.
    
    ### Retrieve some data from magma, which will be in the proper format.
    df <- retrieve(
        magma, projectName = "example", modelName = "rna_seq",
        recordNames = "all",
        attributeNames = c("tube_name", "biospecimen", "cell_number")
        )
    df
    
    updateFromDF(
        target = magma,
        projectName = "example",
        modelName = "rna_seq",
        df = df)
}

}
\seealso{
\code{\link{updateMatrix}} for uploading matrix data

\code{\link{updateValues}} for a more direct replica of \code{magma/update} which is more flexible, though a bit more complicated to use.

\url{https://mountetna.github.io/magma.html#update} for documentation of the underlying \code{magma/update} function.
}
