#' Example Data for mediate_zi_vcoef, plot_sensitivity and mediate_iv Functions
#'
#' A bootstrap random subsample of the DDHP MI-DVD trial data used in Cheng, J.,
#' Cheng, N.F., Guo, Z., Gregorich, S., Ismail, A.I., Gansky, S.A. (2018).
#' In the trial, the enrolled families were examined at Wave 1 (randomization),
#' wave 2 (dental examination and study started, considered as baseline),
#' 6-month follow up, and end of the study (wave 3, 2-year). This bootstrap
#' subsample data contain 100 rows and 9 columns with no missing values.
#' The data are provided only for illustrative purposes.
#'
#' @usage midvd_bt100
#'
#' @format A data frame containing the following variables:
#'
#' \describe{
#'   \item{BrushTimes_W2:}{ Number of times child brushed per day in a typical
#'   week measured at wave 2 (baseline).}
#'   \item{HealthyMeals_W2:}{ A binary variable indicating whether caregivers
#'   gave child healthy meals measured at wave 2 (baseline) (1=Yes, 0=No).}
#'   \item{PBrush_W2:}{ A binary variable indicating whether caregivers made
#'   sure child brushed 2 times per day measured at wave 2 (baseline) (1=Yes,
#'   0=No).}
#'   \item{PDVisit_W2:}{ A binary variable indicating whether caregiver makes
#'   sure child sees dentists every 6 mos measured at wave 2 (baseline) (1=Yes,
#'   0=No).}
#'   \item{PDVisit_6:}{ A binary variable indicating whether caregiver makes
#'   sure child sees dentists every 6 mos measured at 6-month follow up (1=Yes,
#'   0=No).}
#'   \item{PBrushBedt_6:}{ A binary variable indicating whether caregivers made
#'   sure child brushes teeth at bedtime measured at 6-month follow up (1=Yes,
#'   0=No).}
#'   \item{PBrush_6:}{ A binary variable indicating whether caregivers made
#'   sure child brushed 2 times per day measured at 6-month follow up (1=Yes,
#'   0=No).}
#'   \item{intervention:}{ A binary treatment variable (1=intervention
#'   0=Control).}
#'   \item{Untreated_W3:}{ The number of new untreated lesions measured at end
#'   of the 2-year study.}
#' }
#'
#' @source Ismail AI, Ondersma S, Willem Jedele JM, et al. (2011) Evaluation of
#' a brief tailored motivational intervention to prevent early childhood caries.
#' Community Dentistry and Oral Epidemiology 39: 433–448.
#'
#' Cheng, J., Cheng, N.F., Guo, Z., Gregorich, S., Ismail, A.I.,
#'   Gansky, S.A. (2018) Mediation analysis for count and zero-inflated count
#'   data. Statistical Methods in Medical Research. 27(9):2756-2774.
#'
#' @keywords datasets
"midvd_bt100"
