% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xytb-class.R
\name{xytb2hmm}
\alias{xytb2hmm}
\title{xytb object conversion to moveHMM object}
\usage{
xytb2hmm(xytb)
}
\arguments{
\item{xytb}{A xytb object}
}
\value{
A dataframe ready to be used by the function of the `moveHMM`
}
\description{
The function converts a xytb object to a moveHMM dataframe 
(see 
\url{https://CRAN.R-project.org/package=moveHMM}
and \link[moveHMM]{prepData}).
}
\examples{
#track_CAGA_005 is a dataset
xytb<-xytb(track_CAGA_005,"a track",3,.5)
xyhmm <-xytb2hmm(xytb)
#then you can use moveHMM functions
if(requireNamespace("moveHMM")){
	plot(xyhmm)
}
}
\author{
Laurent Dubroca
}
