% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xytb-class.R
\name{resB}
\alias{resB}
\title{Representation of the predicted vs observed behaviour of an xytb object}
\usage{
resB(xytb, type = "time", nob = "-1")
}
\arguments{
\item{xytb}{an xytb object with predicted behaviour.}

\item{type}{\itemize{
  \item \code{time}: plot results in time.
  \item \code{space}: plot results in space.
  \item \code{density}: plot results in space, adding density surface by behaviour.
}}

\item{nob}{character. Define the unobserved value of the behaviour (and
where prediction are done)}
}
\value{
a ggplot
}
\description{
Representation of the predicted vs observed behaviour of an xytb object
}
\examples{
\dontrun{
#track_CAGA_005 is dataset
#generate a complete xytb object with derived (over moving windows of 3, 5
#and 9 points, with quantile at 0, 50 and 100\%) and shifted information on 10
#and 100 points
xytb<-xytb(track_CAGA_005,"a track",c(3,5,9),c(0,.5,1),c(10,100))
#compute a random forest model to predict behaviour (b, where -1 is
#unobserved behaviour) using the derived
#parameters ("actual")
xytb<-modelRF(xytb,"actual",nob="-1",colin=TRUE,varkeep=c("v","thetarel"),
zerovar=TRUE,rfcv=FALSE,step=.9)
#behaviour results:
resB(xytb,type="time",nob="-1")
resB(xytb,type="space",nob="-1")
resB(xytb,type="density",nob="-1")
}
}
\seealso{
See \link[randomForest]{randomForest}
}
\author{
Laurent Dubroca
}
