% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lsirm.R
\name{plot}
\alias{plot}
\title{Plotting the interaction map or summarizing the parameter estimate of fitted LSIRM with box plot.}
\usage{
plot(
  object,
  ...,
  option = "interaction",
  rotation = FALSE,
  cluster = NA,
  which.clust = "item",
  interact = FALSE,
  chain.idx = 1
)
}
\arguments{
\item{object}{Object of class \code{lsirm}.}

\item{...}{Additional arguments for the corresponding function.}

\item{option}{Character; If value is "interaction", draw the interaction map that represents interactions between respondents and items. If value is "beta", draw the boxplot for the posterior samples of beta. If value is "theta", draw the distribution of the theta estimates per total test score for the \code{data}. If value is "alpha", draw the boxplot for the posterior samples of alpha. The "alpha" is only available for 2PL LSIRM.}

\item{rotation}{Logical; If TRUE the latent positions are visualized after oblique (oblimin) rotation.}

\item{cluster}{Character; If value is "neyman" the cluster result are visualized by Point Process Cluster Analysis. If value is "spectral", spectral clustering method applied. Default is NA.}

\item{which.clust}{Character; Choose which values to clustering. "resp" is the option for respondent and "item" is the option for items. Default is "item".}

\item{interact}{Logical; If TRUE, draw the interaction map interactively.}

\item{chain.idx}{Numeric; Index of MCMC chain. Default is 1.}
}
\value{
\code{plot} returns the interaction map or boxplot for parameter estimate.
}
\description{
\link{plot} is used to plot the interaction map of fitted LSIRM or summarizing the parameter estimate of fitted LSIRM with box plot.
}
\examples{
\donttest{

# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5), ncol=10, nrow=50)
lsirm_result <- lsirm(data ~ lsirm1pl())
plot(lsirm_result)

# use oblique rotation
plot(lsirm_result, rotation = TRUE)

# interaction map interactively
plot(lsirm_result, interact = TRUE)

# clustering the respondents or items
plot(lsirm_result, cluster = TRUE)
}
}
