% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.lsbclust.R
\name{int.lsbclust}
\alias{int.lsbclust}
\title{Interaction Clustering in Least Squares Bilinear Clustering}
\usage{
int.lsbclust(data, margin = 3L, delta, nclust, ndim = 2,
  fixed = c("none", "rows", "columns"), nstart = 50, starts = NULL,
  alpha = 0.5, parallel = FALSE, mc.cores = detectCores() - 1,
  maxit = 100, verbose = 1, method = "diag", minsize = 3L,
  return_data = FALSE)
}
\arguments{
\item{data}{A three-way array representing the data.}

\item{margin}{An integer giving the single subscript of \code{data} over which the clustering 
will be applied.}

\item{delta}{A four-element binary vector (logical or numeric) indicating which sum-to-zero 
constraints must be enforced.}

\item{nclust}{An integer giving the desired number of clusters. If it is a vector, the algorithm
will be run for each element.}

\item{ndim}{The required rank for the approximation of the interactions (a scalar).}

\item{fixed}{One of \code{"none"}, \code{"rows"} or \code{"columns"} indicating whether to fix neither
sets of coordinates, or whether to fix the row or column coordinates across clusters respectively.
If a vector is supplied, only the first element will be used.}

\item{nstart}{The number of random starts to use.}

\item{starts}{A list containing starting configurations for the cluster membership vector. If not
supplied, random initializations will be generated.}

\item{alpha}{Numeric value in [0, 1] which determines how the singular values are distributed
between rows and columns.}

\item{parallel}{Logical indicating whether to parallelize over different starts or not.}

\item{mc.cores}{The number of cores to use in case \code{parallel = TRUE}, passed to
\code{\link{makeCluster}}.}

\item{maxit}{The maximum number of iterations allowed.}

\item{verbose}{Integer controlling the amount of information printed: 0 = no information, 
1 = Information on random starts and progress, and 2 = information is printed after
each iteration for the interaction clustering.}

\item{method}{The method for calculating cluster agreement across random starts, passed on
to \code{\link{cl_agreement}}. None is calculated when set to \code{NULL}.}

\item{minsize}{Integer giving the minimum size of cluster to uphold when reinitializing
empty clusters.}

\item{return_data}{Logical indicating whether to include the data in the return
value or not}
}
\value{
An object of class \code{int.lsb}
}
\description{
This function implements the interaction clustering part of the Least Squares Bilinear Clustering
method of Schoonees, Groenen and Van de Velden (2014).
}
\examples{
data("supermarkets")
out <- int.lsbclust(data = supermarkets, margin = 3, delta = c(1,1,0,0), nclust = 4, ndim = 2, 
           fixed = "rows", nstart = 1, alpha = 0)
}
