% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_sp.R
\name{spAsList}
\alias{spAsList}
\title{Create a list of polygons or lines from a spatial data object from the \code{sp} package.}
\usage{
spAsList(x)
}
\arguments{
\item{x}{An \code{sp} spatial data object.}
}
\value{
A list of the relevant components of the spatial data object.
}
\description{
\code{spAsList} is a helper function that should rarely be called directly by the user.
It is an \code{S3} generic function which takes the spatial data object and returns its
components (polygons, lines, et cetera) in a list. Each element could itself be a list.
Different \code{S3} methods are implemented for various spatial data types.
}
\examples{

\dontrun{
library(sp)
library(rworldmap)
world <- getMap(resolution = "coarse")
class(world)
isS4(world)
xy <- spAsList(world)

names(xy)
# because tree has same depth for every leaf unlist is ok
# This is not true otherwise.
uxy <- spunlist(xy)
unlist(xy, recursive=FALSE)
names(uxy)

# here, unlist would be wrong.
}

}
\seealso{
\code{\link{spunlist}}
}
\keyword{internal}
