% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{stop}
\alias{stop}
\title{Stop Log Handler}
\usage{
stop(..., call. = TRUE, domain = NULL, .loggit = NA, echo = get_echo())
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or a single
    condition object.}

\item{call.}{logical, indicating if the call should become part of the
    error message.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated.}

\item{.loggit}{Should the condition message be added to the log?
If \code{NA} the log level set by \code{set_log_level()} is used to determine if the condition should be logged.}

\item{echo}{Should the log entry (json) be echoed to \code{stdout} as well?}
}
\value{
No return value.
}
\description{
This function is identical to base R's \code{\link[base:stop]{stop}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
\dontrun{
  stop("This is a completely false condition")

  stop("This is a completely false condition", echo = FALSE)
}

}
\seealso{
Other handlers: 
\code{\link{message}()},
\code{\link{stopifnot}()},
\code{\link{warning}()}
}
\concept{handlers}
