#' Data from a Simulated Motorcycle Accident
#'
#' A detailed description of these data is available in
#' Schmidt et al. (1981) and in Silverman (1985).
#' The dataset is available in the MASS package.
#' This dataset is also used in  Adam and Gijbels (2021a).
#' A data frame giving a series of measurements of head acceleration in a
#' simulated motorcycle accident, used to test crash helmets.
#'
#' @format A data frame with 142 rows and 2 variables:
#' \describe{
#' \item{times}{in milliseconds after impact.}
#' \item{accel}{in g.}
#' }
#' @references{
#' Adam, C. and Gijbels, I. (2021a). Local polynomial expectile regression.
#' Annals of the Institute of Statistical Mathematics doi:10.1007/s10463-021-00799-y.
#'
#' Schmidt, G., Mattern, R., and Schuler, F. (1981). Biomechanical
#' investigation to determine physical and traumatological differentiation
#' criteria for the maximum load capacity of head and vertebral column
#' with and without protective helmet under the effects of impact. EEC
#' Research Program on Biomechanics of Impacts. Final report Phase III,
#' Project G5, Institut fur Rechtsmedizin, Universitat Heidelberg.
#'
#' Silverman, B. W. (1985). Some aspects of the spline smoothing approach to
#' non-parametric curve fitting. Journal of the Royal Statistical Society
#' Series B, 47, 1–52.
#'}
#'
#' @examples
#' data(mcycle)
#' y=mcycle$accel
#' x=mcycle$times
#' plot(x,y)
"mcycle"
