% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec_version.R
\name{exec_version}
\alias{exec_version}
\title{Get executable version}
\usage{
exec_version(exec)
}
\arguments{
\item{exec}{executable identifier, a single character.
Use one of these values:
\itemize{
\item \code{chrome}: 'Google Chrome' executable
\item \code{firefox}: 'Mozilla Firefox' executable
\item \code{libreoffice}: 'LibreOffice' executable
\item \code{node}: 'node.js' executable
\item \code{npm}: 'npm' executable
\item \code{python}: 'python' executable
\item \code{pip}: 'pip' executable
\item \code{excel}: 'Microsoft Excel' executable
\item \code{word}: 'Microsoft Word' executable
\item \code{powerpoint}: 'Microsoft PowerPoint' executable
}}
}
\value{
a \code{\link[=numeric_version]{numeric_version()}} with the version of the executable found.
}
\description{
get the version of an executable.
}
\examples{
if(exec_available("chrome"))
  message(exec_version("chrome"))
if(exec_available("node"))
  message(exec_version("node"))
if(exec_available("python"))
  message(exec_version("python"))
if(exec_available("libreoffice"))
  message(exec_version("libreoffice"))
if(exec_available("word"))
  message(exec_version("word"))
if(exec_available("powerpoint"))
  message(exec_version("powerpoint"))
if(exec_available("firefox"))
  message(exec_version("firefox"))
}
