% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-fxns.R
\name{plot_multiple_fits}
\alias{plot_multiple_fits}
\title{Plot multiple fits on one graph with model selection results displayed}
\usage{
plot_multiple_fits(time,mass.remaining,model,color,iters,bty,...)
}
\arguments{
\item{time}{vector of time points}

\item{mass.remaining}{vector of mass remaining}

\item{model}{vector of models to fit and plot (see \code{\link{fit_litter}})}

\item{color}{a vector of colors the same length as the number of models}

\item{iters}{parameter passed to \code{\link{fit_litter}}}

\item{bty}{bty}

\item{...}{additional parameters passed to \code{\link{plot}}}
}
\value{
plot of multiple fits, returns invisibly
}
\description{
Plot multiple fits of decomposition trajectories on one graph with model selection results displayed
}
\details{
this function is designed to compare a variety of curve shapes visually and with AIC and BIC simultaneously
}
\examples{
data(pineneedles,package='litterfitter')

plot_multiple_fits(time = pineneedles$Year,
mass.remaining = pineneedles$Mass.remaining,
bty = 'n', model = c('neg.exp', 'weibull'),
xlab = 'Time', ylab = 'Proportion mass remaining',iters=200)


}
\seealso{
\code{\link{fit_litter}} \code{\link{plot.litfit}}
}
\author{
Liu Guofang
}
