% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{getDiffRhythmStats}
\alias{getDiffRhythmStats}
\title{Compute differential rhythm statistics from fitted models}
\usage{
getDiffRhythmStats(fit, rhyStats, conds = fit$conds, dopar = TRUE)
}
\arguments{
\item{fit}{A \code{limorhyde2} object containing data from multiple conditions.}

\item{rhyStats}{A \code{data.table} of rhythmic statistics, as returned by
\code{\link[=getRhythmStats]{getRhythmStats()}}, for fitted models in \code{fit}.}

\item{conds}{A character vector indicating the conditions to compare
pairwise, by default all conditions in \code{fit}.}

\item{dopar}{Logical indicating whether to run calculations in parallel if
a parallel backend is already set up, e.g., using
\code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}. Recommended to minimize runtime.}
}
\value{
A \code{data.table} containing the following differential rhythm
statistics:
\itemize{
\item \code{mean_mesor}
\item \code{mean_peak_trough_amp}
\item \code{mean_rms_amp} (only calculated if \code{rms} to \code{\link[=getRhythmStats]{getRhythmStats()}} was \code{TRUE})
\item \code{diff_mesor}
\item \code{diff_peak_trough_amp}
\item \code{diff_rms_amp} (only calculated if \code{rms} to \code{\link[=getRhythmStats]{getRhythmStats()}} was \code{TRUE})
\item \code{diff_peak_phase}: circular difference between \code{-fit$period/2} and
\code{fit$period/2}
\item \code{diff_trough_phase}: circular difference between \code{-fit$period/2} and
\code{fit$period/2}
\item \code{diff_rhy_dist}: Euclidean distance between polar coordinates
(\code{peak_trough_amp}, \code{peak_phase})
\item \code{rms_diff_rhy}: root mean square difference in mean-centered fitted curves
(only calculated if \code{rms} to \code{\link[=getRhythmStats]{getRhythmStats()}} was \code{TRUE})
}

The stats will be based on the value for \code{cond2} minus the value for \code{cond1}.
The rows of the \code{data.table} depend on the 'fitType' attribute of \code{rhyStats}:
\itemize{
\item 'fitType' is 'posterior_mean' or 'raw': one row per feature per pair of
conditions.
\item 'fitType' is 'posterior_samples': one row per feature per posterior sample
per pair of conditions.
}
}
\description{
This function computes differences in rhythmicity between fitted curves for a
given pair of conditions.
}
\examples{
library('data.table')

# rhythmicity in one condition
y = GSE54650$y
metadata = GSE54650$metadata

fit = getModelFit(y, metadata)
fit = getPosteriorFit(fit)
rhyStats = getRhythmStats(fit, features = c('13170', '13869'))

# rhythmicity and differential rhythmicity in multiple conditions
y = GSE34018$y
metadata = GSE34018$metadata

fit = getModelFit(y, metadata, nKnots = 3L, condColname = 'cond')
fit = getPosteriorFit(fit)
rhyStats = getRhythmStats(fit, features = c('13170', '12686'))
diffRhyStats = getDiffRhythmStats(fit, rhyStats)
}
\seealso{
\code{\link[=getRhythmStats]{getRhythmStats()}}, \code{\link[=getStatsIntervals]{getStatsIntervals()}}
}
