% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.lcc}
\alias{residuals.lcc}
\title{Extract Model Residuals}
\usage{
\method{residuals}{lcc}(object, type, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{type}{an optional character string specifying the type of
residulas to be used. If \code{type = "response"}, the default,
the residuals at level i are obtained by subtracting the fitted
values at that level from the response vector. If \code{type =
"pearson"}, the "response" residuals is divided by the estimated
within-group standard error. If \code{type = "normalized"}, the
normalized residuals are used. Partial matching of arguments is
used, so only the first character needs to be provided.}

\item{...}{optional arguments passed to the \code{residuals.lme}
function.}
}
\value{
Return no value, called for side effects
}
\description{
Extract the residulas from the model used to estimate
  the longitudinal concordance correlation function.
}
\details{
See methods for \code{\link{nlme}} objects to get more
  details.
}
\examples{

\dontrun{
fm1<-lcc(data = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
getVarCov(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{summary.lcc}},
  \code{\link{coef.lcc}}, \code{\link{vcov.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
