% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mev.R
\name{mev}
\alias{mev}
\alias{alogLik.mev_gev}
\alias{alogLik.mev_pp}
\alias{alogLik.mev_gpd}
\alias{alogLik.mev_egp}
\alias{alogLik.mev_rlarg}
\title{Loglikelihood adjustment for mev fits}
\usage{
\method{alogLik}{mev_gev}(x, cluster = NULL, use_vcov = TRUE, ...)

\method{alogLik}{mev_pp}(x, cluster = NULL, use_vcov = TRUE, ...)

\method{alogLik}{mev_gpd}(x, cluster = NULL, use_vcov = TRUE, ...)

\method{alogLik}{mev_egp}(x, cluster = NULL, use_vcov = TRUE, ...)

\method{alogLik}{mev_rlarg}(x, cluster = NULL, use_vcov = TRUE, ...)
}
\arguments{
\item{x}{A fitted model object with certain associated S3 methods.
See \strong{Details}.}

\item{cluster}{A vector or factor indicating from which cluster the
  respective log-likelihood contributions from \code{loglik} originate.
  The length of \code{cluster} must be consistent with the \code{estfun}
  method to be used in the estimation of the 'meat' \code{V} of the sandwich
  estimator of the covariance matrix of the parameters to be passed to
  \code{\link[chandwich]{adjust_loglik}}.  In most cases, \code{cluster}
  must have length equal to the number of observations in data.  The
  exception is the GP (only) model (\code{binom = FALSE}), where the
  \code{cluster} may either contain a value for each observation in the raw
  data, or for each threshold exceedance in the data.

  If \code{cluster} is not supplied (is \code{NULL}) then it is
  assumed that each observation forms its own cluster.
  See \strong{Details} for further details.}

\item{use_vcov}{A logical scalar.  Should we use the \code{vcov} S3 method
for \code{x} (if this exists) to estimate the Hessian of the independence
loglikelihood to be passed as the argument \code{H} to
\code{\link[chandwich]{adjust_loglik}}?
Otherwise, \code{H} is estimated inside
\code{\link[chandwich]{adjust_loglik}} using
\code{\link[stats:optim]{optimHess}}.}

\item{...}{Further arguments to be passed to the functions in the
sandwich package \code{\link[sandwich]{meat}} (if \code{cluster = NULL}),
or \code{\link[sandwich:vcovCL]{meatCL}} (if \code{cluster} is not
\code{NULL}).}
}
\value{
An object inheriting from class \code{"chandwich"}.  See
  \code{\link[chandwich]{adjust_loglik}}.
  \code{class(x)} is a vector of length 5. The first 3 components are
  \code{c("lax", "chandwich", "mev")}.
  The 4th component depends on which model was fitted.
  \code{"gev"} if \code{\link[mev]{fit.gev}} was used;
  \code{"gpd"} if \code{\link[mev]{fit.gpd}} was used;
  \code{"pp"} \code{\link[mev]{fit.pp}} was used;
  \code{"egp"} \code{\link[mev]{fit.egp}} was used;
  \code{"rlarg"} \code{\link[mev]{fit.rlarg}} was used;
  The 5th component is \code{"stat"} (for stationary).
}
\description{
S3 \code{alogLik} method to perform loglikelihood adjustment for fitted
extreme value model objects returned from the functions
\code{\link[mev]{fit.gev}}, \code{\link[mev]{fit.gpd}}, and
\code{\link[mev]{fit.pp}} and \code{\link[mev]{fit.rlarg}} in the
mev package.
}
\details{
See \code{\link{alogLik}} for details.

If \code{x} was returned from \code{\link[mev]{fit.pp}} then the data
\code{xdat} supplied to \code{\link[mev]{fit.pp}} must contain \emph{all}
the data, both threshold exceedances and non-exceedances.
}
\examples{
# We need the mev package
got_mev <- requireNamespace("mev", quietly = TRUE)

if (got_mev) {
  library(mev)
  # An example from the mev::gev.fit documentation
  gev_mev <- fit.gev(revdbayes::portpirie)
  adj_gev_mev <- alogLik(gev_mev)
  summary(adj_gev_mev)

  # Use simulated data
  set.seed(1112019)
  x <- revdbayes::rgp(365 * 10, loc = 0, scale = 1, shape = 0.1)
  pfit <- fit.pp(x, threshold = 1, npp = 365)
  adj_pfit <- alogLik(pfit)
  summary(adj_pfit)

  # An example from the mev::fit.gpd documentation
  gpd_mev <- fit.gpd(eskrain, threshold = 35, method = 'Grimshaw')
  adj_gpd_mev <- alogLik(gpd_mev)
  summary(adj_gpd_mev)

  # An example from the mev::fit.egp documentation
  # (model = "egp1" and model = "egp3" also work)
  xdat <- evd::rgpd(n = 100, loc = 0, scale = 1, shape = 0.5)
  fitted <- fit.egp(xdat = xdat, thresh = 1, model = "egp2", show = FALSE)
  adj_fitted <- alogLik(fitted)
  summary(adj_fitted)

  # An example from the mev::fit.rlarg documentation
  set.seed(31102019)
  xdat <- rrlarg(n = 10, loc = 0, scale = 1, shape = 0.1, r = 4)
  fitr <- fit.rlarg(xdat)
  adj_fitr <- alogLik(fitr)
  summary(adj_fitr)
}
}
\references{
Chandler, R. E. and Bate, S. (2007). Inference for clustered
  data using the independence loglikelihood. \emph{Biometrika},
  \strong{94}(1), 167-183. \doi{10.1093/biomet/asm015}

Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \doi{10.1214/09-AOAS292}

Zeileis (2006) Object-Oriented Computation and Sandwich
  Estimators.  \emph{Journal of Statistical Software}, \strong{16}, 1-16.
  \doi{10.18637/jss.v016.i09}
}
\seealso{
\code{\link{alogLik}}: loglikelihood adjustment for model fits.
}
