% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_reduction.R
\name{reduce_tsne}
\alias{reduce_tsne}
\title{Reduce Dimensionality with t-SNE}
\usage{
reduce_tsne(df, n = 2, ignore = NULL, quiet = FALSE, plot = TRUE, ...)
}
\arguments{
\item{df}{Dataframe}

\item{n}{Integer. Number of dimensions to reduce to.}

\item{ignore}{Character vector. Names of columns to ignore.}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be shown.}

\item{plot}{Boolean. Create plots?}

\item{...}{Additional parameters passed to \code{Rtsne::Rtsne}}
}
\value{
List with reduced dataframe and possible plots.
}
\description{
t-SNE takes high-dimensional data and reduces it to a low-dimensional
graph (1-3 dimensions). Unlike PCA, t-SNE can reduce dimensions with
non-linear relationships. PCA attempts to draw the best fitting line
through the distribution. T-SNE calculates a similarity measure
based on the distance between points instead of trying to maximize variance.
}
\examples{
\dontrun{
data("iris")
df <- subset(iris, select = c(-Species))
df$id <- seq_len(nrow(df))
reduce_tsne(df, ignore = "id", max_iter = 800, perplexity = 20)
}
}
\seealso{
Other Dimensionality: 
\code{\link{reduce_pca}()}

Other Clusters: 
\code{\link{clusterKmeans}()},
\code{\link{clusterOptimalK}()},
\code{\link{clusterVisualK}()},
\code{\link{reduce_pca}()}
}
\concept{Clusters}
\concept{Dimensionality}
