% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour_palettes.R
\name{plot_palette}
\alias{plot_palette}
\title{Plot Palette Colours}
\usage{
plot_palette(fill, colour = "black", id = NA, limit = 12, ...)
}
\arguments{
\item{fill}{Vector. List of colours for fills.}

\item{colour}{Vector. List of colours for colours.}

\item{id}{Vector. ID for each color.}

\item{limit}{Integer. Show only first n values.}

\item{...}{Additional parameters.}
}
\value{
Plot with \code{fill} colours and \code{colour} counter-colours
if provided.
}
\description{
This function plots a list of colours
}
\examples{
# Simply pass a vector
pal <- lares_pal("simple")
plot_palette(pal)
# Or fill + color named vector
pal <- lares_pal("pal")
plot_palette(fill = names(pal), colour = as.vector(pal))
}
\seealso{
Other Themes: 
\code{\link{gg_fill_customs}()},
\code{\link{lares_pal}()},
\code{\link{theme_lares}()}
}
\concept{Themes}
