% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{iter_seeds}
\alias{iter_seeds}
\title{Iterate Seeds on AutoML}
\usage{
iter_seeds(df, y, tries = 10, ...)
}
\arguments{
\item{df}{Dataframe. Dataframe containing all your data, including
the dependent variable labeled as \code{'tag'}. If you want to define
which variable should be used instead, use the \code{y} parameter.}

\item{y}{Variable or Character. Name of the dependent variable or response.}

\item{tries}{Integer. Number of iterations}

\item{...}{Additional arguments passed to \code{h2o_automl}}
}
\value{
data.frame with performance results by seed tried on every row.
}
\description{
This functions lets the user iterate and search for best seed. Note that if
the results change a lot, you are having a high variance in your data.
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}
}
\concept{Machine Learning}
